/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.MaleSocketFactory;
import jmri.managers.AbstractManager;

public abstract class AbstractBaseManager<E extends NamedBean>
extends AbstractManager<E>
implements BaseManager<E> {
    protected List<MaleSocketFactory<E>> _maleSocketFactories = new ArrayList<MaleSocketFactory<E>>();

    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, null);
        VetoableChangeListener[] vetoableChangeListenerArray = this.vetoableChangeSupport.getVetoableChangeListeners();
        int n = vetoableChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableChangeListener vc = vetoableChangeListenerArray[n2];
            vc.vetoableChange(evt);
            ++n2;
        }
    }

    protected abstract E castBean(MaleSocket var1);

    @Override
    public final void deleteBean(@Nonnull E n, @Nonnull String property) throws PropertyVetoException {
        this.deleteBean((MaleSocket)n, property);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void deleteBean(@Nonnull MaleSocket socket, @Nonnull String property) throws PropertyVetoException {
        int i = 0;
        while (i < socket.getChildCount()) {
            FemaleSocket child = socket.getChild(i);
            if (child.isConnected()) {
                MaleSocket maleSocket = child.getConnectedSocket();
                maleSocket.getManager().deleteBean(maleSocket, property);
            }
            ++i;
        }
        this.fireVetoableChange(property, socket);
        if (property.equals("DoDelete")) {
            this.deregister(this.castBean(socket));
            socket.dispose();
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void deregister(@Nonnull E s) {
        Object bean = this.getBySystemName(s.getSystemName());
        if (bean == null) {
            throw new IllegalArgumentException(String.valueOf(s.getSystemName()) + " is not registered in manager");
        }
        super.deregister(bean);
    }

    @Override
    public final Manager.NameValidity validSystemNameFormat(String systemName) {
        return LogixNG_Manager.validSystemNameFormat(this.getSubSystemNamePrefix(), systemName);
    }

    @Override
    public void register(@Nonnull E s) {
        throw new RuntimeException("Use BaseManager.registerBean() instead");
    }

    @Override
    public E registerBean(@Nonnull E s) {
        E bean = s;
        for (MaleSocketFactory<E> factory : this._maleSocketFactories) {
            bean = factory.encapsulateMaleSocket(this, bean);
        }
        super.register(bean);
        return bean;
    }

    @Override
    public void registerMaleSocketFactory(MaleSocketFactory<E> factory) {
        this._maleSocketFactories.add(factory);
    }
}

