/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBase
extends AbstractNamedBean
implements Base {
    protected boolean _listenersAreRegistered = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractBase.class);

    public AbstractBase(String sys) throws NamedBean.BadSystemNameException {
        super(sys);
    }

    public AbstractBase(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base deepCopyChildren(Base original, Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        int i = 0;
        while (i < original.getChildCount()) {
            this.getChild(i).setName(original.getChild(i).getName(), true);
            if (original.getChild(i).isConnected()) {
                Base childTree = original.getChild(i).getConnectedSocket().getDeepCopy(systemNames, userNames);
                this.getChild(i).connect((MaleSocket)childTree);
            }
            ++i;
        }
        return this;
    }

    @Override
    public ConditionalNG getConditionalNG() {
        if (this instanceof ConditionalNG) {
            return (ConditionalNG)((Object)this);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getConditionalNG();
    }

    @Override
    public final LogixNG getLogixNG() {
        if (this instanceof LogixNG) {
            return (LogixNG)((Object)this);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getLogixNG();
    }

    @Override
    public final Base getRoot() {
        Base item = this;
        while (item.getParent() != null) {
            item = item.getParent();
        }
        return item;
    }

    @Override
    public final boolean setParentForAllChildren(List<String> errors) {
        boolean result = true;
        int i = 0;
        while (i < this.getChildCount()) {
            FemaleSocket femaleSocket = this.getChild(i);
            femaleSocket.setParent(this);
            if (femaleSocket.isConnected()) {
                MaleSocket connectedSocket = femaleSocket.getConnectedSocket();
                if (connectedSocket.getParent() != null && connectedSocket.getParent() != femaleSocket) {
                    errors.add(Bundle.getMessage("DuplicateParentMessage", connectedSocket.getSystemName(), connectedSocket.getParent().getSystemName(), this.getSystemName()));
                    log.error("The child {} already has the parent {} so it cannot be added to {}", new Object[]{connectedSocket.getSystemName(), connectedSocket.getParent().getSystemName(), this.getSystemName()});
                    femaleSocket.disconnect();
                    result = false;
                } else {
                    connectedSocket.setParent(femaleSocket);
                    result = result && connectedSocket.setParentForAllChildren(errors);
                }
            }
            ++i;
        }
        return result;
    }

    protected abstract void registerListenersForThisClass();

    protected abstract void unregisterListenersForThisClass();

    @Override
    public final void registerListeners() {
        if (this.isActive()) {
            this.registerListenersForThisClass();
            int i = 0;
            while (i < this.getChildCount()) {
                this.getChild(i).registerListeners();
                ++i;
            }
        }
    }

    @Override
    public final void unregisterListeners() {
        this.unregisterListenersForThisClass();
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).unregisterListeners();
            ++i;
        }
    }

    @Override
    public final boolean isActive() {
        return this.isEnabled() && (this.getParent() == null || this.getParent().isActive());
    }

    protected void printTreeRow(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String currentIndent, MutableInt lineNumber) {
        if (settings._printLineNumbers) {
            writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
        }
        writer.append(currentIndent);
        writer.append(this.getLongDescription(locale));
        writer.println();
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, locale, writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, String currentIndent, MutableInt lineNumber) {
        this.printTreeRow(settings, locale, writer, currentIndent, lineNumber);
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).printTree(settings, locale, writer, indent, String.valueOf(currentIndent) + indent, lineNumber);
            ++i;
        }
    }

    @Override
    public void getUsageTree(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("## {} :: {}", (Object)level, (Object)this.getLongDescription());
        ++level;
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).getUsageTree(level, bean, report, cdl);
            ++i;
        }
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return suffix1.compareTo(suffix2);
    }

    protected abstract void disposeMe();

    @Override
    public final void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).dispose();
            ++i;
        }
        this.unregisterListeners();
        this.disposeMe();
    }

    protected void assertListenersAreNotRegistered(Logger log, String method) {
        if (this._listenersAreRegistered) {
            RuntimeException e = new RuntimeException(String.valueOf(method) + " must not be called when listeners are registered");
            log.error(String.valueOf(method) + " must not be called when listeners are registered", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void getListenerRefsIncludingChildren(List<String> list) {
        list.addAll(this.getListenerRefs());
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).getListenerRefsIncludingChildren(list);
            ++i;
        }
    }
}

