/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.expressions.ExpressionScript;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.FileUtil;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionScriptSwing
extends AbstractDigitalExpressionSwing {
    public static final int NUM_COLUMNS_TEXT_FIELDS = 20;
    private JTabbedPane _tabbedPaneOperationType;
    private JPanel _panelOperationTypeDirect;
    private JPanel _panelOperationTypeReference;
    private JPanel _panelOperationTypeLocalVariable;
    private JPanel _panelOperationTypeFormula;
    private JComboBox<ExpressionScript.OperationType> _operationComboBox;
    private JTextField _scriptOperationReferenceTextField;
    private JTextField _scriptOperationLocalVariableTextField;
    private JTextField _scriptOperationFormulaTextField;
    private JTabbedPane _tabbedPaneScriptType;
    private JPanel _panelScriptTypeDirect;
    private JPanel _panelScriptTypeReference;
    private JPanel _panelScriptTypeLocalVariable;
    private JPanel _panelScriptTypeFormula;
    private JFileChooser scriptFileChooser;
    private JTextField _scriptTextField;
    private JTextField _scriptReferenceTextField;
    private JTextField _scriptLocalVariableTextField;
    private JTextField _scriptFormulaTextField;
    private JLabel _registerListenerLabel;
    private JLabel _unregisterListenerLabel;
    private JTextField _registerListener;
    private JTextField _unregisterListener;
    private static final Logger log = LoggerFactory.getLogger(ExpressionScriptSwing.class);

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ExpressionScript action = (ExpressionScript)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel actionPanel = new JPanel();
        this._tabbedPaneOperationType = new JTabbedPane();
        this._panelOperationTypeDirect = new JPanel();
        this._panelOperationTypeDirect.setLayout(new BoxLayout(this._panelOperationTypeDirect, 1));
        this._panelOperationTypeReference = new JPanel();
        this._panelOperationTypeReference.setLayout(new BoxLayout(this._panelOperationTypeReference, 1));
        this._panelOperationTypeLocalVariable = new JPanel();
        this._panelOperationTypeLocalVariable.setLayout(new BoxLayout(this._panelOperationTypeLocalVariable, 1));
        this._panelOperationTypeFormula = new JPanel();
        this._panelOperationTypeFormula.setLayout(new BoxLayout(this._panelOperationTypeFormula, 1));
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.Direct.toString(), this._panelOperationTypeDirect);
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.Reference.toString(), this._panelOperationTypeReference);
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelOperationTypeLocalVariable);
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.Formula.toString(), this._panelOperationTypeFormula);
        this._operationComboBox = new JComboBox();
        ExpressionScript.OperationType[] operationTypeArray = ExpressionScript.OperationType.values();
        int n = operationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionScript.OperationType e2 = operationTypeArray[n2];
            this._operationComboBox.addItem(e2);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._operationComboBox);
        this._panelOperationTypeDirect.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeDirect.add(this._operationComboBox);
        this._scriptOperationReferenceTextField = new JTextField();
        this._scriptOperationReferenceTextField.setColumns(20);
        this._panelOperationTypeReference.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeReference.add(this._scriptOperationReferenceTextField);
        this._scriptOperationLocalVariableTextField = new JTextField();
        this._scriptOperationLocalVariableTextField.setColumns(20);
        this._panelOperationTypeLocalVariable.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeLocalVariable.add(this._scriptOperationLocalVariableTextField);
        this._scriptOperationFormulaTextField = new JTextField();
        this._scriptOperationFormulaTextField.setColumns(20);
        this._panelOperationTypeFormula.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeFormula.add(this._scriptOperationFormulaTextField);
        this._tabbedPaneScriptType = new JTabbedPane();
        this._panelScriptTypeDirect = new JPanel();
        this._panelScriptTypeReference = new JPanel();
        this._panelScriptTypeReference.setLayout(new BoxLayout(this._panelScriptTypeReference, 1));
        this._panelScriptTypeLocalVariable = new JPanel();
        this._panelScriptTypeLocalVariable.setLayout(new BoxLayout(this._panelScriptTypeLocalVariable, 1));
        this._panelScriptTypeFormula = new JPanel();
        this._panelScriptTypeFormula.setLayout(new BoxLayout(this._panelScriptTypeFormula, 1));
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.Direct.toString(), this._panelScriptTypeDirect);
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.Reference.toString(), this._panelScriptTypeReference);
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelScriptTypeLocalVariable);
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.Formula.toString(), this._panelScriptTypeFormula);
        JButton _actionSelectFileButton = new JButton("...");
        _actionSelectFileButton.setMaximumSize(_actionSelectFileButton.getPreferredSize());
        _actionSelectFileButton.setToolTipText(Bundle.getMessage("FileButtonHint"));
        _actionSelectFileButton.addActionListener(e -> {
            this.scriptFileChooser = new JFileChooser(FileUtil.getScriptsPath());
            this.scriptFileChooser.setFileFilter(new FileNameExtensionFilter("Python script files", "py"));
            this.scriptFileChooser.rescanCurrentDirectory();
            int retVal = this.scriptFileChooser.showOpenDialog(null);
            if (retVal == 0) {
                try {
                    this._scriptTextField.setText(FileUtil.getPortableFilename(this.scriptFileChooser.getSelectedFile().getCanonicalPath()));
                }
                catch (IOException ex) {
                    log.error("exception setting file location: {}", (Throwable)ex);
                    this._scriptTextField.setText("");
                }
            }
        });
        this._panelScriptTypeDirect.add(_actionSelectFileButton);
        JPanel _scriptTextPanel = new JPanel();
        _scriptTextPanel.setLayout(new BoxLayout(_scriptTextPanel, 1));
        this._scriptTextField = new JTextField(30);
        _scriptTextPanel.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        _scriptTextPanel.add(this._scriptTextField);
        this._panelScriptTypeDirect.add(_scriptTextPanel);
        this._scriptReferenceTextField = new JTextField();
        this._scriptReferenceTextField.setColumns(20);
        this._panelScriptTypeReference.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        this._panelScriptTypeReference.add(this._scriptReferenceTextField);
        this._scriptLocalVariableTextField = new JTextField();
        this._scriptLocalVariableTextField.setColumns(20);
        this._panelScriptTypeLocalVariable.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        this._panelScriptTypeLocalVariable.add(this._scriptLocalVariableTextField);
        this._scriptFormulaTextField = new JTextField();
        this._scriptFormulaTextField.setColumns(20);
        this._panelScriptTypeFormula.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        this._panelScriptTypeFormula.add(this._scriptFormulaTextField);
        if (action != null) {
            switch (action.getOperationAddressing()) {
                case Direct: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getOperationAddressing().name());
                }
            }
            this._operationComboBox.setSelectedItem((Object)action.getOperationType());
            this._scriptOperationReferenceTextField.setText(action.getOperationReference());
            this._scriptOperationLocalVariableTextField.setText(action.getOperationLocalVariable());
            this._scriptOperationFormulaTextField.setText(action.getOperationFormula());
            switch (action.getScriptAddressing()) {
                case Direct: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getScriptAddressing().name());
                }
            }
            this._scriptTextField.setText(action.getScript());
            this._scriptReferenceTextField.setText(action.getScriptReference());
            this._scriptLocalVariableTextField.setText(action.getScriptLocalVariable());
            this._scriptFormulaTextField.setText(action.getScriptFormula());
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneOperationType, this._tabbedPaneScriptType};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionScript_Components"), components);
        for (JComponent c : componentList) {
            actionPanel.add(c);
        }
        this.panel.add(actionPanel);
        JPanel listernerPanel = new JPanel();
        this.panel.add(listernerPanel);
        this._registerListenerLabel = new JLabel(Bundle.getMessage("ExpressionScript_RegisterListener"));
        this._unregisterListenerLabel = new JLabel(Bundle.getMessage("ExpressionScript_UnregisterListener"));
        this._registerListener = new JTextField(30);
        this._unregisterListener = new JTextField(30);
        if (action != null) {
            this._registerListener.setText(action.getRegisterListenerScript());
            this._unregisterListener.setText(action.getUnregisterListenerScript());
        }
        listernerPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        listernerPanel.add((Component)this._registerListenerLabel, c);
        this._registerListenerLabel.setLabelFor(this._registerListener);
        c.gridy = 1;
        listernerPanel.add((Component)this._unregisterListenerLabel, c);
        this._unregisterListenerLabel.setLabelFor(this._unregisterListener);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        listernerPanel.add((Component)this._registerListener, c);
        c.gridy = 1;
        listernerPanel.add((Component)this._unregisterListener, c);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block9: {
            ExpressionScript action = new ExpressionScript("IQDE1", null);
            try {
                if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeReference) {
                    action.setOperationReference(this._scriptOperationReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setScriptFormula(this._scriptFormulaTextField.getText());
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeDirect) {
                    action.setScriptAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeReference) {
                    action.setScriptAddressing(NamedBeanAddressing.Reference);
                    break block9;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeLocalVariable) {
                    action.setScriptAddressing(NamedBeanAddressing.LocalVariable);
                    break block9;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeFormula) {
                    action.setScriptAddressing(NamedBeanAddressing.Formula);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneScriptType has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ExpressionScript expression = new ExpressionScript(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        ExpressionScript action;
        block15: {
            if (!(object instanceof ExpressionScript)) {
                throw new IllegalArgumentException("object must be an ExpressionScript but is a: " + object.getClass().getName());
            }
            action = (ExpressionScript)object;
            try {
                if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeDirect) {
                    action.setOperationAddressing(NamedBeanAddressing.Direct);
                    action.setOperationType((ExpressionScript.OperationType)((Object)this._operationComboBox.getSelectedItem()));
                } else if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeReference) {
                    action.setOperationAddressing(NamedBeanAddressing.Reference);
                    action.setOperationReference(this._scriptOperationReferenceTextField.getText());
                } else if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeLocalVariable) {
                    action.setOperationAddressing(NamedBeanAddressing.LocalVariable);
                    action.setOperationLocalVariable(this._scriptOperationLocalVariableTextField.getText());
                } else if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeFormula) {
                    action.setOperationAddressing(NamedBeanAddressing.Formula);
                    action.setOperationFormula(this._scriptOperationFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneOperationType has unknown selection");
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeDirect) {
                    action.setScriptAddressing(NamedBeanAddressing.Direct);
                    action.setScript(this._scriptTextField.getText());
                    break block15;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeReference) {
                    action.setScriptAddressing(NamedBeanAddressing.Reference);
                    action.setScriptReference(this._scriptReferenceTextField.getText());
                    break block15;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeLocalVariable) {
                    action.setScriptAddressing(NamedBeanAddressing.LocalVariable);
                    action.setScriptLocalVariable(this._scriptLocalVariableTextField.getText());
                    break block15;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeFormula) {
                    action.setScriptAddressing(NamedBeanAddressing.Formula);
                    action.setScriptFormula(this._scriptFormulaTextField.getText());
                    break block15;
                }
                throw new IllegalArgumentException("_tabbedPaneAspectType has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
        action.setRegisterListenerScript(this._registerListener.getText());
        action.setUnregisterListenerScript(this._unregisterListener.getText());
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ExpressionScript_Short");
    }

    @Override
    public void dispose() {
    }
}

