/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.ExpressionReporter;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class ExpressionReporterSwing
extends AbstractDigitalExpressionSwing {
    private BeanSelectPanel<Reporter> _reporterBeanPanel;
    private JComboBox<ExpressionReporter.ReporterValue> _reporterValueComboBox;
    private JComboBox<ExpressionReporter.ReporterOperation> _reporterOperationComboBox;
    private JCheckBox _caseInsensitiveCheckBox;
    private JTabbedPane _tabbedPane;
    private JTabbedPane _tabbedPaneCompareTo;
    private BeanSelectPanel<Memory> _compareToMemoryBeanPanel;
    private JPanel _reporterValuePanel;
    private JPanel _compareToConstant;
    private JPanel _compareToMemory;
    private JPanel _compareToLocalVariable;
    private JPanel _compareToRegEx;
    private JTextField _compareToConstantTextField;
    private JTextField _compareToLocalVariableTextField;
    private JTextField _compareToRegExTextField;

    private void enableDisableCompareTo() {
        ExpressionReporter.ReporterOperation mo = this._reporterOperationComboBox.getItemAt(this._reporterOperationComboBox.getSelectedIndex());
        boolean enable = mo.hasExtraValue();
        this._tabbedPaneCompareTo.setEnabled(enable);
        ((JPanel)this._tabbedPaneCompareTo.getSelectedComponent()).getComponent(0).setEnabled(enable);
        boolean regEx = mo == ExpressionReporter.ReporterOperation.MatchRegex || mo == ExpressionReporter.ReporterOperation.NotMatchRegex;
        this._tabbedPane.setEnabledAt(0, !regEx);
        this._tabbedPane.setEnabledAt(1, regEx);
        this._tabbedPane.setSelectedIndex(regEx ? 1 : 0);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ExpressionReporter expression = (ExpressionReporter)object;
        this.panel = new JPanel();
        this._reporterBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(ReporterManager.class), null);
        this._reporterValuePanel = new JPanel();
        this._reporterValueComboBox = new JComboBox();
        ExpressionReporter.ReporterValue[] reporterValueArray = ExpressionReporter.ReporterValue.values();
        int n = reporterValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionReporter.ReporterValue e2 = reporterValueArray[n2];
            this._reporterValueComboBox.addItem(e2);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._reporterValueComboBox);
        this._reporterValuePanel.add(this._reporterValueComboBox);
        JPanel operationAndCasePanel = new JPanel();
        operationAndCasePanel.setLayout(new BoxLayout(operationAndCasePanel, 1));
        this._reporterOperationComboBox = new JComboBox();
        ExpressionReporter.ReporterOperation[] reporterOperationArray = ExpressionReporter.ReporterOperation.values();
        int n3 = reporterOperationArray.length;
        n = 0;
        while (n < n3) {
            ExpressionReporter.ReporterOperation e3 = reporterOperationArray[n];
            this._reporterOperationComboBox.addItem(e3);
            ++n;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._reporterOperationComboBox);
        if (expression == null) {
            this._reporterOperationComboBox.setSelectedItem((Object)ExpressionReporter.ReporterOperation.Equal);
        }
        operationAndCasePanel.add(this._reporterOperationComboBox);
        this._reporterOperationComboBox.addActionListener(e -> this.enableDisableCompareTo());
        this._caseInsensitiveCheckBox = new JCheckBox(Bundle.getMessage("ExpressionReporter_CaseInsensitive"));
        operationAndCasePanel.add(this._caseInsensitiveCheckBox);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPaneCompareTo = new JTabbedPane();
        this._tabbedPane.addTab("", this._tabbedPaneCompareTo);
        this._compareToConstant = new JPanel();
        this._compareToMemory = new JPanel();
        this._compareToLocalVariable = new JPanel();
        this._compareToRegEx = new JPanel();
        this._tabbedPaneCompareTo.addTab(ExpressionReporter.CompareTo.Value.toString(), this._compareToConstant);
        this._tabbedPaneCompareTo.addTab(ExpressionReporter.CompareTo.Memory.toString(), this._compareToMemory);
        this._tabbedPaneCompareTo.addTab(ExpressionReporter.CompareTo.LocalVariable.toString(), this._compareToLocalVariable);
        this._tabbedPane.addTab(ExpressionReporter.CompareTo.RegEx.toString(), this._compareToRegEx);
        this._compareToConstantTextField = new JTextField(30);
        this._compareToConstant.add(this._compareToConstantTextField);
        this._compareToMemoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._compareToMemory.add(this._compareToMemoryBeanPanel);
        this._compareToLocalVariableTextField = new JTextField(30);
        this._compareToLocalVariable.add(this._compareToLocalVariableTextField);
        this._compareToRegExTextField = new JTextField(30);
        this._compareToRegEx.add(this._compareToRegExTextField);
        if (expression != null) {
            if (expression.getReporter() != null) {
                this._reporterBeanPanel.setDefaultNamedBean(expression.getReporter().getBean());
            }
            if (expression.getMemory() != null) {
                this._compareToMemoryBeanPanel.setDefaultNamedBean(expression.getMemory().getBean());
            }
            switch (expression.getCompareTo()) {
                case Value: 
                case RegEx: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToConstant);
                    break;
                }
                case Memory: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToMemory);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToLocalVariable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + expression.getCompareTo().name());
                }
            }
            this._reporterValueComboBox.setSelectedItem((Object)expression.getReporterValue());
            this._reporterOperationComboBox.setSelectedItem((Object)expression.getReporterOperation());
            this._caseInsensitiveCheckBox.setSelected(expression.getCaseInsensitive());
            this._compareToConstantTextField.setText(expression.getConstantValue());
            this._compareToLocalVariableTextField.setText(expression.getLocalVariable());
            this._compareToRegExTextField.setText(expression.getRegEx());
        }
        JComponent[] components = new JComponent[]{this._reporterBeanPanel, this._reporterValuePanel, operationAndCasePanel, this._tabbedPane};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionReporter_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
        this.enableDisableCompareTo();
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        if (this._reporterBeanPanel.getNamedBean() == null) {
            errorMessages.add(Bundle.getMessage("Reporter_No_Reporter"));
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ExpressionReporter expression = new ExpressionReporter(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ExpressionReporter)) {
            throw new IllegalArgumentException("object must be an ExpressionReporter but is a: " + object.getClass().getName());
        }
        ExpressionReporter expression = (ExpressionReporter)object;
        Reporter reporter = this._reporterBeanPanel.getNamedBean();
        if (reporter != null) {
            NamedBeanHandle<Reporter> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(reporter.getDisplayName(), reporter);
            expression.setReporter(handle);
        } else {
            expression.removeReporter();
        }
        expression.setReporterValue(this._reporterValueComboBox.getItemAt(this._reporterValueComboBox.getSelectedIndex()));
        expression.setReporterOperation(this._reporterOperationComboBox.getItemAt(this._reporterOperationComboBox.getSelectedIndex()));
        expression.setCaseInsensitive(this._caseInsensitiveCheckBox.isSelected());
        if (!this._compareToMemoryBeanPanel.isEmpty() && this._tabbedPane.getSelectedComponent() == this._tabbedPaneCompareTo && this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToMemory) {
            Memory memory = this._compareToMemoryBeanPanel.getNamedBean();
            if (memory != null) {
                NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
                expression.setMemory(handle);
            } else {
                expression.removeMemory();
            }
        } else {
            expression.removeMemory();
        }
        if (this._tabbedPane.getSelectedComponent() == this._tabbedPaneCompareTo) {
            if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToConstant) {
                expression.setCompareTo(ExpressionReporter.CompareTo.Value);
                expression.setConstantValue(this._compareToConstantTextField.getText());
                return;
            } else if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToMemory) {
                expression.setCompareTo(ExpressionReporter.CompareTo.Memory);
                return;
            } else {
                if (this._tabbedPaneCompareTo.getSelectedComponent() != this._compareToLocalVariable) throw new IllegalArgumentException("_tabbedPaneLight has unknown selection");
                expression.setCompareTo(ExpressionReporter.CompareTo.LocalVariable);
                expression.setLocalVariable(this._compareToLocalVariableTextField.getText());
            }
            return;
        } else {
            expression.setCompareTo(ExpressionReporter.CompareTo.RegEx);
            expression.setRegEx(this._compareToRegExTextField.getText());
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Reporter_Short");
    }

    @Override
    public void dispose() {
    }
}

