/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.ExpressionMemory;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class ExpressionMemorySwing
extends AbstractDigitalExpressionSwing {
    private BeanSelectPanel<Memory> _memoryBeanPanel;
    private JComboBox<ExpressionMemory.MemoryOperation> _memoryOperationComboBox;
    private JCheckBox _caseInsensitiveCheckBox;
    private JTabbedPane _tabbedPane;
    private JTabbedPane _tabbedPaneCompareTo;
    private BeanSelectPanel<Memory> _compareToMemoryBeanPanel;
    private JPanel _compareToConstant;
    private JPanel _compareToMemory;
    private JPanel _compareToLocalVariable;
    private JPanel _compareToRegEx;
    private JTextField _compareToConstantTextField;
    private JTextField _compareToLocalVariableTextField;
    private JTextField _compareToRegExTextField;

    private void enableDisableCompareTo() {
        ExpressionMemory.MemoryOperation mo = this._memoryOperationComboBox.getItemAt(this._memoryOperationComboBox.getSelectedIndex());
        boolean enable = mo.hasExtraValue();
        this._tabbedPaneCompareTo.setEnabled(enable);
        ((JPanel)this._tabbedPaneCompareTo.getSelectedComponent()).getComponent(0).setEnabled(enable);
        boolean regEx = mo == ExpressionMemory.MemoryOperation.MatchRegex || mo == ExpressionMemory.MemoryOperation.NotMatchRegex;
        this._tabbedPane.setEnabledAt(0, !regEx);
        this._tabbedPane.setEnabledAt(1, regEx);
        this._tabbedPane.setSelectedIndex(regEx ? 1 : 0);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ExpressionMemory expression = (ExpressionMemory)object;
        this.panel = new JPanel();
        this._memoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        JPanel operationAndCasePanel = new JPanel();
        operationAndCasePanel.setLayout(new BoxLayout(operationAndCasePanel, 1));
        this._memoryOperationComboBox = new JComboBox();
        ExpressionMemory.MemoryOperation[] memoryOperationArray = ExpressionMemory.MemoryOperation.values();
        int n = memoryOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionMemory.MemoryOperation e2 = memoryOperationArray[n2];
            this._memoryOperationComboBox.addItem(e2);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._memoryOperationComboBox);
        operationAndCasePanel.add(this._memoryOperationComboBox);
        this._memoryOperationComboBox.addActionListener(e -> this.enableDisableCompareTo());
        this._caseInsensitiveCheckBox = new JCheckBox(Bundle.getMessage("ExpressionMemory_CaseInsensitive"));
        operationAndCasePanel.add(this._caseInsensitiveCheckBox);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPaneCompareTo = new JTabbedPane();
        this._tabbedPane.addTab("", this._tabbedPaneCompareTo);
        this._compareToConstant = new JPanel();
        this._compareToMemory = new JPanel();
        this._compareToLocalVariable = new JPanel();
        this._compareToRegEx = new JPanel();
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.Value.toString(), this._compareToConstant);
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.Memory.toString(), this._compareToMemory);
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.LocalVariable.toString(), this._compareToLocalVariable);
        this._tabbedPane.addTab(ExpressionMemory.CompareTo.RegEx.toString(), this._compareToRegEx);
        this._compareToConstantTextField = new JTextField(30);
        this._compareToConstant.add(this._compareToConstantTextField);
        this._compareToMemoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._compareToMemory.add(this._compareToMemoryBeanPanel);
        this._compareToLocalVariableTextField = new JTextField(30);
        this._compareToLocalVariable.add(this._compareToLocalVariableTextField);
        this._compareToRegExTextField = new JTextField(30);
        this._compareToRegEx.add(this._compareToRegExTextField);
        if (expression != null) {
            if (expression.getMemory() != null) {
                this._memoryBeanPanel.setDefaultNamedBean(expression.getMemory().getBean());
            }
            if (expression.getOtherMemory() != null) {
                this._compareToMemoryBeanPanel.setDefaultNamedBean(expression.getOtherMemory().getBean());
            }
            switch (expression.getCompareTo()) {
                case Value: 
                case RegEx: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToConstant);
                    break;
                }
                case Memory: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToMemory);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToLocalVariable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + expression.getCompareTo().name());
                }
            }
            this._memoryOperationComboBox.setSelectedItem((Object)expression.getMemoryOperation());
            this._caseInsensitiveCheckBox.setSelected(expression.getCaseInsensitive());
            this._compareToConstantTextField.setText(expression.getConstantValue());
            this._compareToLocalVariableTextField.setText(expression.getLocalVariable());
            this._compareToRegExTextField.setText(expression.getRegEx());
        }
        JComponent[] components = new JComponent[]{this._memoryBeanPanel, operationAndCasePanel, this._tabbedPane};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionMemory_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
        this.enableDisableCompareTo();
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ExpressionMemory expression = new ExpressionMemory(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ExpressionMemory)) {
            throw new IllegalArgumentException("object must be an ExpressionMemory but is a: " + object.getClass().getName());
        }
        ExpressionMemory expression = (ExpressionMemory)object;
        Memory memory = this._memoryBeanPanel.getNamedBean();
        if (memory != null) {
            NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
            expression.setMemory(handle);
        } else {
            expression.removeMemory();
        }
        expression.setMemoryOperation(this._memoryOperationComboBox.getItemAt(this._memoryOperationComboBox.getSelectedIndex()));
        expression.setCaseInsensitive(this._caseInsensitiveCheckBox.isSelected());
        if (!this._compareToMemoryBeanPanel.isEmpty() && this._tabbedPane.getSelectedComponent() == this._tabbedPaneCompareTo && this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToMemory) {
            Memory otherMemory = this._compareToMemoryBeanPanel.getNamedBean();
            if (otherMemory != null) {
                NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(otherMemory.getDisplayName(), otherMemory);
                expression.setOtherMemory(handle);
            } else {
                expression.removeOtherMemory();
            }
        } else {
            expression.removeOtherMemory();
        }
        if (this._tabbedPane.getSelectedComponent() == this._tabbedPaneCompareTo) {
            if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToConstant) {
                expression.setCompareTo(ExpressionMemory.CompareTo.Value);
                expression.setConstantValue(this._compareToConstantTextField.getText());
                return;
            } else if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToMemory) {
                expression.setCompareTo(ExpressionMemory.CompareTo.Memory);
                return;
            } else {
                if (this._tabbedPaneCompareTo.getSelectedComponent() != this._compareToLocalVariable) throw new IllegalArgumentException("_tabbedPaneLight has unknown selection");
                expression.setCompareTo(ExpressionMemory.CompareTo.LocalVariable);
                expression.setLocalVariable(this._compareToLocalVariableTextField.getText());
            }
            return;
        } else {
            expression.setCompareTo(ExpressionMemory.CompareTo.RegEx);
            expression.setRegEx(this._compareToRegExTextField.getText());
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Memory_Short");
    }

    @Override
    public void dispose() {
    }
}

