/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.ExpressionClock;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.util.swing.JComboBoxUtil;

public class ExpressionClockSwing
extends AbstractDigitalExpressionSwing {
    private JComboBox<ExpressionClock.Type> _stateComboBox;
    private JComboBox<Is_IsNot_Enum> _is_IsNot_ComboBox;
    private JTextField _beginTextField;
    private JTextField _endTextField;
    private int _beginMinutes;
    private int _endMinutes;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        Enum e;
        ExpressionClock expression = (ExpressionClock)object;
        this.panel = new JPanel();
        this._stateComboBox = new JComboBox();
        Object object2 = ExpressionClock.Type.values();
        int n = ((ExpressionClock.Type[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            e = object2[n2];
            this._stateComboBox.addItem((ExpressionClock.Type)e);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._stateComboBox);
        this._is_IsNot_ComboBox = new JComboBox();
        object2 = Is_IsNot_Enum.values();
        n = ((Is_IsNot_Enum[])object2).length;
        n2 = 0;
        while (n2 < n) {
            e = object2[n2];
            this._is_IsNot_ComboBox.addItem((Is_IsNot_Enum)e);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._is_IsNot_ComboBox);
        this._beginTextField = new JTextField(4);
        this._beginTextField.setText(ExpressionClock.formatTime(0));
        this._endTextField = new JTextField(4);
        this._endTextField.setText(ExpressionClock.formatTime(0));
        if (expression != null) {
            this._stateComboBox.setSelectedItem((Object)expression.getType());
            this._is_IsNot_ComboBox.setSelectedItem((Object)expression.get_Is_IsNot());
            this._beginTextField.setText(ExpressionClock.formatTime(expression.getBeginTime()));
            this._endTextField.setText(ExpressionClock.formatTime(expression.getEndTime()));
        }
        JComponent[] components = new JComponent[]{this._stateComboBox, this._is_IsNot_ComboBox, this._beginTextField, this._endTextField};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionClock_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        this._beginMinutes = this.validateTime(errorMessages, this._beginTextField);
        this._endMinutes = this.validateTime(errorMessages, this._endTextField);
        return errorMessages.isEmpty();
    }

    private int validateTime(List<String> errorMessages, JTextField timeField) {
        int minutes = 0;
        try {
            LocalTime newHHMM = LocalTime.parse(timeField.getText().trim(), DateTimeFormatter.ofPattern("H:mm"));
            minutes = newHHMM.getHour() * 60 + newHHMM.getMinute();
            if (minutes < 0 || minutes > 1439) {
                errorMessages.add(Bundle.getMessage("Clock_RangeError"));
            }
        }
        catch (DateTimeParseException ex) {
            errorMessages.add(Bundle.getMessage("Clock_ParseError", ex.getParsedString()));
        }
        return minutes;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ExpressionClock expression = new ExpressionClock(systemName, userName);
        expression.setType(ExpressionClock.Type.FastClock);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ExpressionClock)) {
            throw new IllegalArgumentException("object must be an ExpressionClock but is a: " + object.getClass().getName());
        }
        ExpressionClock expression = (ExpressionClock)object;
        expression.setType(this._stateComboBox.getItemAt(this._stateComboBox.getSelectedIndex()));
        expression.set_Is_IsNot((Is_IsNot_Enum)((Object)this._is_IsNot_ComboBox.getSelectedItem()));
        expression.setRange(this._beginMinutes, this._endMinutes);
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Clock_Short");
    }

    @Override
    public void dispose() {
    }
}

