/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.DigitalCallModule;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.CallModuleParameterTableModel;
import jmri.util.swing.JComboBoxUtil;

public class DigitalCallModuleSwing
extends AbstractDigitalExpressionSwing {
    private JComboBox<ModuleItem> _moduleComboBox;
    private CallModuleParameterTableModel _moduleParametersTableModel;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ArrayList<Module.ParameterData> parameterData;
        if (object != null && !(object instanceof DigitalCallModule)) {
            throw new IllegalArgumentException("object is not a Module: " + object.getClass().getName());
        }
        DigitalCallModule callModule = (DigitalCallModule)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel beanPanel = new JPanel();
        beanPanel.add(new JLabel("Module:"));
        this._moduleComboBox = new JComboBox();
        this._moduleComboBox.addItem(new ModuleItem(null));
        for (Module m : InstanceManager.getDefault(ModuleManager.class).getNamedBeanSet()) {
            if (!"DefaultFemaleDigitalExpressionSocket".equals(m.getRootSocketType().getName())) continue;
            ModuleItem mi = new ModuleItem(m);
            this._moduleComboBox.addItem(mi);
            if (callModule == null || callModule.getModule() == null || callModule.getModule().getBean() != m) continue;
            this._moduleComboBox.setSelectedItem(mi);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._moduleComboBox);
        beanPanel.add(this._moduleComboBox);
        this.panel.add(beanPanel);
        Module module = null;
        if (callModule != null) {
            if (callModule.getModule() != null) {
                module = callModule.getModule().getBean();
            }
            parameterData = callModule.getParameterData();
        } else {
            parameterData = new ArrayList();
        }
        JPanel tablePanel = new JPanel();
        JTable table = new JTable();
        this._moduleParametersTableModel = new CallModuleParameterTableModel(module, parameterData);
        table.setModel(this._moduleParametersTableModel);
        table.setDefaultRenderer(SymbolTable.InitialValueType.class, new CallModuleParameterTableModel.TypeCellRenderer());
        table.setDefaultEditor(SymbolTable.InitialValueType.class, new CallModuleParameterTableModel.InitialValueCellEditor());
        table.setDefaultRenderer(Module.ReturnValueType.class, new CallModuleParameterTableModel.TypeCellRenderer());
        table.setDefaultEditor(Module.ReturnValueType.class, new CallModuleParameterTableModel.ReturnValueCellEditor());
        this._moduleParametersTableModel.setColumnsForComboBoxes(table);
        JScrollPane scrollpane = new JScrollPane(table);
        scrollpane.setPreferredSize(new Dimension(400, 200));
        tablePanel.add((Component)scrollpane, "Center");
        this.panel.add(tablePanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        DigitalCallModule action = new DigitalCallModule(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof DigitalCallModule)) {
            throw new IllegalArgumentException("object is not a Module: " + object.getClass().getName());
        }
        DigitalCallModule callModule = (DigitalCallModule)object;
        ModuleItem mi = this._moduleComboBox.getItemAt(this._moduleComboBox.getSelectedIndex());
        if (mi._module != null) {
            callModule.setModule(mi._module);
            callModule.getParameterData().clear();
            callModule.getParameterData().addAll(this._moduleParametersTableModel.getParameters());
        } else {
            callModule.removeModule();
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("DigitalCallModule_Short");
    }

    @Override
    public void dispose() {
    }

    private static class ModuleItem {
        private final Module _module;

        public ModuleItem(Module m) {
            this._module = m;
        }

        public String toString() {
            if (this._module == null) {
                return "";
            }
            return this._module.getDisplayName();
        }
    }
}

