/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.Antecedent;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntecedentSwing
extends AbstractDigitalExpressionSwing {
    private JTextField _antecedent;
    private static final Logger log = LoggerFactory.getLogger(AntecedentSwing.class);

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        Antecedent expression = (Antecedent)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel antecedentPanel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("Antecedent_Antecedent"));
        this._antecedent = new JTextField();
        this._antecedent.setColumns(40);
        if (expression != null) {
            this._antecedent.setText(expression.getAntecedent());
        }
        antecedentPanel.add(label);
        antecedentPanel.add(this._antecedent);
        this.panel.add(antecedentPanel);
        JLabel descriptionLabel = new JLabel(Bundle.getMessage("Antecedent_Description"));
        JPanel subPanel = new JPanel();
        subPanel.add(descriptionLabel);
        this.panel.add(subPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        Antecedent expression = new Antecedent(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof Antecedent)) {
            throw new IllegalArgumentException("object must be an Antecedent but is a: " + object.getClass().getName());
        }
        Antecedent expression = (Antecedent)object;
        try {
            expression.setAntecedent(this._antecedent.getText());
        }
        catch (JmriException ex) {
            log.error("Error when parsing formula", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Antecedent_Short");
    }

    @Override
    public void dispose() {
    }
}

