/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.AnalogExpressionConstant;
import jmri.jmrit.logixng.expressions.swing.AbstractAnalogExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;

public class AnalogExpressionConstantSwing
extends AbstractAnalogExpressionSwing {
    private JTextField _constant;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        AnalogExpressionConstant expression = (AnalogExpressionConstant)object;
        this.panel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("AnalogExpressionConstant_Constant"));
        this._constant = new JTextField();
        this._constant.setColumns(10);
        if (expression != null) {
            this._constant.setText(String.format("%1.2f", expression.getValue()));
        }
        this.panel.add(label);
        this.panel.add(this._constant);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        if (this._constant.getText().isEmpty()) {
            return true;
        }
        try {
            Double.parseDouble(this._constant.getText());
        }
        catch (NumberFormatException numberFormatException) {
            errorMessages.add(Bundle.getMessage("AnalogExpressionConstant_NotANumber", this._constant.getText()));
            return false;
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        AnalogExpressionConstant expression = new AnalogExpressionConstant(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(AnalogExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof AnalogExpressionConstant)) {
            throw new IllegalArgumentException("object must be an AnalogExpressionConstant but is a: " + object.getClass().getName());
        }
        AnalogExpressionConstant expression = (AnalogExpressionConstant)object;
        if (!this._constant.getText().isEmpty()) {
            expression.setValue(Double.parseDouble(this._constant.getText()));
        } else {
            expression.setValue(0.0);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("AnalogExpressionConstant_Short");
    }

    @Override
    public void dispose() {
    }
}

