/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.expressions.ExpressionSignalHead;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ExpressionSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        ExpressionSignalHead p = (ExpressionSignalHead)o;
        Element element = new Element("ExpressionSignalHead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<SignalHead> signalHead = p.getSignalHead();
        if (signalHead != null) {
            element.addContent((Content)new Element("signalHead").addContent(signalHead.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("queryAddressing").addContent(p.getQueryAddressing().name()));
        element.addContent((Content)new Element("queryType").addContent(p.getQueryType().name()));
        element.addContent((Content)new Element("queryReference").addContent(p.getQueryReference()));
        element.addContent((Content)new Element("queryLocalVariable").addContent(p.getQueryLocalVariable()));
        element.addContent((Content)new Element("queryFormula").addContent(p.getQueryFormula()));
        element.addContent((Content)new Element("appearanceAddressing").addContent(p.getAppearanceAddressing().name()));
        element.addContent((Content)new Element("appearance").addContent(Integer.toString(p.getAppearance())));
        element.addContent((Content)new Element("appearanceReference").addContent(p.getAppearanceReference()));
        element.addContent((Content)new Element("appearanceLocalVariable").addContent(p.getAppearanceLocalVariable()));
        element.addContent((Content)new Element("appearanceFormula").addContent(p.getAppearanceFormula()));
        signalHead = p.getExampleSignalHead();
        if (signalHead != null) {
            element.addContent((Content)new Element("exampleSignalHead").addContent(signalHead.getName()));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        SignalHead signalHead;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionSignalHead h = new ExpressionSignalHead(sys, uname);
        this.loadCommon(h, shared);
        Element signalHeadName = shared.getChild("signalHead");
        if (signalHeadName != null) {
            signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName.getTextTrim());
            if (signalHead != null) {
                h.setSignalHead(signalHead);
            } else {
                h.removeSignalHead();
            }
        }
        try {
            Element appearanceElement;
            Element queryType;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("queryAddressing")) != null) {
                h.setQueryAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((queryType = shared.getChild("queryType")) != null) {
                h.setQueryType(ExpressionSignalHead.QueryType.valueOf(queryType.getTextTrim()));
            }
            if ((elem = shared.getChild("queryReference")) != null) {
                h.setQueryReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("queryLocalVariable")) != null) {
                h.setQueryLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("queryFormula")) != null) {
                h.setQueryFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("appearanceAddressing")) != null) {
                h.setAppearanceAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((appearanceElement = shared.getChild("appearance")) != null) {
                try {
                    int appearance = Integer.parseInt(appearanceElement.getTextTrim());
                    h.setAppearance(appearance);
                }
                catch (NumberFormatException e) {
                    log.error("cannot parse apperance: " + appearanceElement.getTextTrim(), (Throwable)e);
                }
            }
            if ((elem = shared.getChild("appearanceReference")) != null) {
                h.setAppearanceReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("appearanceLocalVariable")) != null) {
                h.setAppearanceLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("appearanceFormula")) != null) {
                h.setAppearanceFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        signalHeadName = shared.getChild("exampleSignalHead");
        if (signalHeadName != null) {
            signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName.getTextTrim());
            if (signalHead != null) {
                h.setExampleSignalHead(signalHead);
            } else {
                h.removeSignalHead();
            }
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

