/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.expressions.ExpressionReporter;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionReporterXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        String variableName;
        ExpressionReporter p = (ExpressionReporter)o;
        Element element = new Element("ExpressionReporter");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Reporter> reporter = p.getReporter();
        if (reporter != null) {
            element.addContent((Content)new Element("reporter").addContent(reporter.getName()));
        }
        element.addContent((Content)new Element("reporterValue").addContent(p.getReporterValue().name()));
        element.addContent((Content)new Element("reporterOperation").addContent(p.getReporterOperation().name()));
        element.addContent((Content)new Element("compareTo").addContent(p.getCompareTo().name()));
        element.addContent((Content)new Element("caseInsensitive").addContent(p.getCaseInsensitive() ? "yes" : "no"));
        element.addContent((Content)new Element("constant").addContent(p.getConstantValue()));
        NamedBeanHandle<Memory> memory = p.getMemory();
        if (memory != null) {
            element.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        if ((variableName = p.getLocalVariable()) != null) {
            element.addContent((Content)new Element("variable").addContent(variableName));
        }
        element.addContent((Content)new Element("regEx").addContent(p.getRegEx()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element caseInsensitive;
        Element compareTo;
        Element reporterOperation;
        Element reporterValue;
        Element regEx;
        Element constant;
        Element variableName;
        Element memoryName;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionReporter h = new ExpressionReporter(sys, uname);
        this.loadCommon(h, shared);
        Element reporterName = shared.getChild("reporter");
        if (reporterName != null) {
            Reporter m = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterName.getTextTrim());
            if (m != null) {
                h.setReporter(m);
            } else {
                h.removeReporter();
            }
        }
        if ((memoryName = shared.getChild("memory")) != null) {
            Memory m = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
            if (m != null) {
                h.setMemory(m);
            } else {
                h.removeMemory();
            }
        }
        if ((variableName = shared.getChild("variable")) != null) {
            h.setLocalVariable(variableName.getTextTrim());
        }
        if ((constant = shared.getChild("constant")) != null) {
            h.setConstantValue(constant.getText());
        }
        if ((regEx = shared.getChild("regEx")) != null) {
            h.setRegEx(regEx.getText());
        }
        if ((reporterValue = shared.getChild("reporterValue")) != null) {
            h.setReporterValue(ExpressionReporter.ReporterValue.valueOf(reporterValue.getTextTrim()));
        }
        if ((reporterOperation = shared.getChild("reporterOperation")) != null) {
            h.setReporterOperation(ExpressionReporter.ReporterOperation.valueOf(reporterOperation.getTextTrim()));
        }
        if ((compareTo = shared.getChild("compareTo")) != null) {
            h.setCompareTo(ExpressionReporter.CompareTo.valueOf(compareTo.getTextTrim()));
        }
        if ((caseInsensitive = shared.getChild("caseInsensitive")) != null) {
            h.setCaseInsensitive("yes".equals(caseInsensitive.getTextTrim()));
        } else {
            h.setCaseInsensitive(false);
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

