/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.expressions.ExpressionMemory;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionMemoryXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        String variableName;
        NamedBeanHandle<Memory> otherMemory;
        ExpressionMemory p = (ExpressionMemory)o;
        Element element = new Element("ExpressionMemory");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Memory> memory = p.getMemory();
        if (memory != null) {
            element.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        if ((otherMemory = p.getOtherMemory()) != null) {
            element.addContent((Content)new Element("otherMemory").addContent(otherMemory.getName()));
        }
        if ((variableName = p.getLocalVariable()) != null) {
            element.addContent((Content)new Element("variable").addContent(variableName));
        }
        element.addContent((Content)new Element("compareTo").addContent(p.getCompareTo().name()));
        element.addContent((Content)new Element("memoryOperation").addContent(p.getMemoryOperation().name()));
        element.addContent((Content)new Element("caseInsensitive").addContent(p.getCaseInsensitive() ? "yes" : "no"));
        element.addContent((Content)new Element("constant").addContent(p.getConstantValue()));
        element.addContent((Content)new Element("regEx").addContent(p.getRegEx()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element caseInsensitive;
        Element compareTo;
        Element memoryOperation;
        Element regEx;
        Element constant;
        Element variableName;
        Element otherMemoryName;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionMemory h = new ExpressionMemory(sys, uname);
        this.loadCommon(h, shared);
        Element memoryName = shared.getChild("memory");
        if (memoryName != null) {
            Memory m = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
            if (m != null) {
                h.setMemory(m);
            } else {
                h.removeMemory();
            }
        }
        if ((otherMemoryName = shared.getChild("otherMemory")) != null) {
            Memory m = InstanceManager.getDefault(MemoryManager.class).getMemory(otherMemoryName.getTextTrim());
            if (m != null) {
                h.setOtherMemory(m);
            } else {
                h.removeOtherMemory();
            }
        }
        if ((variableName = shared.getChild("variable")) != null) {
            h.setLocalVariable(variableName.getTextTrim());
        }
        if ((constant = shared.getChild("constant")) != null) {
            h.setConstantValue(constant.getText());
        }
        if ((regEx = shared.getChild("regEx")) != null) {
            h.setRegEx(regEx.getText());
        }
        if ((memoryOperation = shared.getChild("memoryOperation")) != null) {
            h.setMemoryOperation(ExpressionMemory.MemoryOperation.valueOf(memoryOperation.getTextTrim()));
        }
        if ((compareTo = shared.getChild("compareTo")) != null) {
            h.setCompareTo(ExpressionMemory.CompareTo.valueOf(compareTo.getTextTrim()));
        }
        if ((caseInsensitive = shared.getChild("caseInsensitive")) != null) {
            h.setCaseInsensitive("yes".equals(caseInsensitive.getTextTrim()));
        } else {
            h.setCaseInsensitive(false);
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

