/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.expressions.ExpressionLocalVariable;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionLocalVariableXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        NamedBeanHandle<Memory> memoryName;
        String otherVariableName;
        ExpressionLocalVariable p = (ExpressionLocalVariable)o;
        Element element = new Element("ExpressionLocalVariable");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        String variableName = p.getLocalVariable();
        if (variableName != null) {
            element.addContent((Content)new Element("variable").addContent(variableName));
        }
        if ((otherVariableName = p.getOtherLocalVariable()) != null) {
            element.addContent((Content)new Element("otherVariable").addContent(otherVariableName));
        }
        if ((memoryName = p.getMemory()) != null) {
            element.addContent((Content)new Element("memory").addContent(memoryName.getName()));
        }
        element.addContent((Content)new Element("compareTo").addContent(p.getCompareTo().name()));
        element.addContent((Content)new Element("variableOperation").addContent(p.getVariableOperation().name()));
        element.addContent((Content)new Element("caseInsensitive").addContent(p.getCaseInsensitive() ? "yes" : "no"));
        element.addContent((Content)new Element("constant").addContent(p.getConstantValue()));
        element.addContent((Content)new Element("regEx").addContent(p.getRegEx()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element caseInsensitive;
        Element variableOperation;
        Element compareTo;
        Element regEx;
        Element constant;
        Element memoryName;
        Element otherVariableName;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionLocalVariable h = new ExpressionLocalVariable(sys, uname);
        this.loadCommon(h, shared);
        Element variableName = shared.getChild("variable");
        if (variableName != null) {
            h.setLocalVariable(variableName.getTextTrim());
        }
        if ((otherVariableName = shared.getChild("otherVariable")) != null) {
            h.setOtherLocalVariable(otherVariableName.getTextTrim());
        }
        if ((memoryName = shared.getChild("memory")) != null) {
            Memory t = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
            if (t != null) {
                h.setMemory(t);
            } else {
                h.removeMemory();
            }
        }
        if ((constant = shared.getChild("constant")) != null) {
            h.setConstantValue(constant.getText());
        }
        if ((regEx = shared.getChild("regEx")) != null) {
            h.setRegEx(regEx.getText());
        }
        if ((compareTo = shared.getChild("compareTo")) != null) {
            h.setCompareTo(ExpressionLocalVariable.CompareTo.valueOf(compareTo.getTextTrim()));
        }
        if ((variableOperation = shared.getChild("variableOperation")) != null) {
            h.setVariableOperation(ExpressionLocalVariable.VariableOperation.valueOf(variableOperation.getTextTrim()));
        }
        if ((caseInsensitive = shared.getChild("caseInsensitive")) != null) {
            h.setCaseInsensitive("yes".equals(caseInsensitive.getTextTrim()));
        } else {
            h.setCaseInsensitive(false);
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

