/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.ExpressionClock;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionClockXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ExpressionClockXml.class);

    @Override
    public Element store(Object o) {
        ExpressionClock p = (ExpressionClock)o;
        Element element = new Element("ExpressionClock");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)new Element("is_isNot").addContent(p.get_Is_IsNot().name()));
        element.addContent((Content)new Element("type").addContent(p.getType().name()));
        element.addContent((Content)new Element("beginTime").addContent(Integer.toString(p.getBeginTime())));
        element.addContent((Content)new Element("endTime").addContent(Integer.toString(p.getEndTime())));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element type;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionClock h = new ExpressionClock(sys, uname);
        this.loadCommon(h, shared);
        Element is_IsNot = shared.getChild("is_isNot");
        if (is_IsNot != null) {
            h.set_Is_IsNot(Is_IsNot_Enum.valueOf(is_IsNot.getTextTrim()));
        }
        if ((type = shared.getChild("type")) != null) {
            h.setType(ExpressionClock.Type.valueOf(type.getTextTrim()));
        }
        int beginTime = 0;
        int endTime = 0;
        Element beginTimeElement = shared.getChild("beginTime");
        Element endTimeElement = shared.getChild("endTime");
        if (beginTimeElement != null) {
            try {
                beginTime = Integer.parseInt(beginTimeElement.getTextTrim());
            }
            catch (NumberFormatException e) {
                log.error("cannot parse beginTime: " + beginTimeElement.getTextTrim(), (Throwable)e);
            }
        }
        if (endTimeElement != null) {
            try {
                endTime = Integer.parseInt(endTimeElement.getTextTrim());
                h.setRange(beginTime, endTime);
            }
            catch (NumberFormatException e) {
                log.error("cannot parse endTime: " + endTimeElement.getTextTrim(), (Throwable)e);
            }
        }
        h.setRange(beginTime, endTime);
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

