/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import java.awt.GraphicsEnvironment;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.expressions.ExpressionBlock;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionBlockXml
extends AbstractNamedBeanManagerConfigXML {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.logixng.actions.ActionBundle");

    @Override
    public Element store(Object o) {
        ExpressionBlock p = (ExpressionBlock)o;
        Element element = new Element("ExpressionBlock");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Block> block = p.getBlock();
        if (block != null) {
            element.addContent((Content)new Element("block").addContent(block.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("is_isNot").addContent(p.get_Is_IsNot().name()));
        element.addContent((Content)new Element("stateAddressing").addContent(p.getStateAddressing().name()));
        element.addContent((Content)new Element("blockState").addContent(p.getBeanState().name()));
        element.addContent((Content)new Element("stateReference").addContent(p.getStateReference()));
        element.addContent((Content)new Element("stateLocalVariable").addContent(p.getStateLocalVariable()));
        element.addContent((Content)new Element("stateFormula").addContent(p.getStateFormula()));
        element.addContent((Content)new Element("dataAddressing").addContent(p.getDataAddressing().name()));
        element.addContent((Content)new Element("dataReference").addContent(p.getDataReference()));
        element.addContent((Content)new Element("dataLocalVariable").addContent(p.getDataLocalVariable()));
        element.addContent((Content)new Element("dataFormula").addContent(p.getDataFormula()));
        element.addContent((Content)new Element("blockValue").addContent(p.getBlockValue()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionBlock h = new ExpressionBlock(sys, uname);
        this.loadCommon(h, shared);
        Element blockName = shared.getChild("block");
        if (blockName != null) {
            Block t = (Block)InstanceManager.getDefault(BlockManager.class).getNamedBean(blockName.getTextTrim());
            if (t != null) {
                h.setBlock(t);
            } else {
                h.removeBlock();
            }
        }
        try {
            Element blockState;
            Element is_IsNot;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((is_IsNot = shared.getChild("is_isNot")) != null) {
                h.set_Is_IsNot(Is_IsNot_Enum.valueOf(is_IsNot.getTextTrim()));
            }
            if ((elem = shared.getChild("stateAddressing")) != null) {
                h.setStateAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((blockState = shared.getChild("blockState")) != null) {
                String state = blockState.getTextTrim();
                if (state.equals("MemoryMatches")) {
                    state = "ValueMatches";
                }
                h.setBeanState(ExpressionBlock.BlockState.valueOf(state));
            }
            if ((elem = shared.getChild("stateReference")) != null) {
                h.setStateReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateLocalVariable")) != null) {
                h.setStateLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateFormula")) != null) {
                h.setStateFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataAddressing")) != null) {
                h.setDataAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("dataReference")) != null) {
                h.setDataReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataLocalVariable")) != null) {
                h.setDataLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataFormula")) != null) {
                h.setDataFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("blockValue")) != null) {
                h.setBlockValue(elem.getTextTrim());
            }
            if ((elem = shared.getChild("blockConstant")) != null) {
                h.setBlockValue(elem.getTextTrim());
            }
            if ((elem = shared.getChild("blockMemory")) != null) {
                String memoryName = elem.getTextTrim();
                h.setBlockValue(">>> " + elem.getTextTrim() + " <<<");
                if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
                    JOptionPane.showMessageDialog(null, rb.getString("ActionBlock_MemoryChange"), String.valueOf(rb.getString("ActionBlock_MemoryTitle")) + " " + memoryName, 2);
                }
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

