/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.DigitalFormula;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalFormulaXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DigitalFormulaXml.class);

    @Override
    public Element store(Object o) {
        DigitalFormula p = (DigitalFormula)o;
        Element element = new Element("DigitalFormula");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e = new Element("Expressions");
        int i = 0;
        while (i < p.getChildCount()) {
            String socketManager;
            String socketSystemName;
            Element e2 = new Element("Socket");
            e2.addContent((Content)new Element("socketName").addContent(p.getChild(i).getName()));
            MaleSocket socket = p.getChild(i).getConnectedSocket();
            if (socket != null) {
                socketSystemName = socket.getSystemName();
                socketManager = socket.getManager().getClass().getName();
            } else {
                socketSystemName = p.getExpressionSystemName(i);
                socketManager = p.getExpressionManager(i);
            }
            if (socketSystemName != null) {
                e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
            }
            if (socketManager != null) {
                e2.addContent((Content)new Element("manager").addContent(socketManager));
            }
            e.addContent((Content)e2);
            ++i;
        }
        element.addContent((Content)e);
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        ArrayList<DigitalFormula.SocketData> expressionSystemNames = new ArrayList<DigitalFormula.SocketData>();
        Element actionElement = shared.getChild("Expressions");
        for (Element socketElement : actionElement.getChildren()) {
            String socketName = socketElement.getChild("socketName").getTextTrim();
            Element systemNameElement = socketElement.getChild("systemName");
            String systemName = null;
            if (systemNameElement != null) {
                systemName = systemNameElement.getTextTrim();
            }
            Element managerElement = socketElement.getChild("manager");
            String manager = null;
            if (managerElement != null) {
                manager = managerElement.getTextTrim();
            }
            expressionSystemNames.add(new DigitalFormula.SocketData(socketName, systemName, manager));
        }
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        DigitalFormula h = new DigitalFormula(sys, uname, expressionSystemNames);
        this.loadCommon(h, shared);
        Element formula = shared.getChild("formula");
        if (formula != null) {
            try {
                h.setFormula(formula.getTextTrim());
            }
            catch (ParserException e) {
                log.error("cannot set formula: " + formula.getTextTrim(), (Throwable)e);
            }
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

