/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerOnce
extends AbstractDigitalExpression
implements FemaleSocketListener {
    private String _childExpressionSystemName;
    private final FemaleDigitalExpressionSocket _childExpression = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, "E");
    private boolean _childLastState = false;
    private static final Logger log = LoggerFactory.getLogger(TriggerOnce.class);

    public TriggerOnce(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        TriggerOnce copy = new TriggerOnce(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public boolean evaluate() throws JmriException {
        if (this._childExpression.evaluate() && !this._childLastState) {
            this._childLastState = true;
            return true;
        }
        this._childLastState = this._childExpression.evaluate();
        return false;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index == 0) {
            return this._childExpression;
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._childExpression) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._childExpressionSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._childExpression) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._childExpressionSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "TriggerOnce_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "TriggerOnce_Long");
    }

    public String getChildSocketSystemName() {
        return this._childExpressionSystemName;
    }

    public void setChildSocketSystemName(String systemName) {
        this._childExpressionSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._childExpression.isConnected() || !this._childExpression.getConnectedSocket().getSystemName().equals(this._childExpressionSystemName)) {
                String socketSystemName = this._childExpressionSystemName;
                this._childExpression.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._childExpression.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._childExpression.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

