/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractAnalogExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSinceMidnight
extends AbstractAnalogExpression
implements PropertyChangeListener {
    private Type _type = Type.FastClock;
    private Timebase _fastClock;
    TimerTask timerTask = null;
    private final int millisInAMinute = 60000;
    private static final Logger log = LoggerFactory.getLogger(TimeSinceMidnight.class);

    public TimeSinceMidnight(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        AnalogExpressionManager manager = InstanceManager.getDefault(AnalogExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        TimeSinceMidnight copy = new TimeSinceMidnight(sysName, userName);
        copy.setComment(this.getComment());
        copy.setType(this._type);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public void setType(Type type) {
        this.assertListenersAreNotRegistered(log, "setType");
        this._type = type;
        this._fastClock = this._type == Type.FastClock ? InstanceManager.getDefault(Timebase.class) : null;
    }

    public Type getType() {
        return this._type;
    }

    @Override
    public double evaluate() {
        Calendar currentTime = null;
        switch (this._type) {
            case SystemClock: {
                currentTime = Calendar.getInstance();
                break;
            }
            case FastClock: {
                if (this._fastClock == null) {
                    return 0.0;
                }
                currentTime = Calendar.getInstance();
                currentTime.setTime(this._fastClock.getTime());
                break;
            }
            default: {
                throw new UnsupportedOperationException("_type has unknown value: " + this._type.name());
            }
        }
        return currentTime.get(11) * 60 + currentTime.get(12);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "TimeSinceMidnight_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        switch (this._type) {
            case SystemClock: {
                return Bundle.getMessage(locale, "TimeSinceMidnight_Long_SystemClock");
            }
            case FastClock: {
                return Bundle.getMessage(locale, "TimeSinceMidnight_Long_FastClock");
            }
        }
        throw new RuntimeException("Unknown value of _timerType: " + this._type.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            switch (this._type) {
                case SystemClock: {
                    this.scheduleTimer();
                    break;
                }
                case FastClock: {
                    this._fastClock.addPropertyChangeListener("time", this);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("_type has unknown value: " + this._type.name());
                }
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            switch (this._type) {
                case SystemClock: {
                    if (this.timerTask == null) break;
                    this.timerTask.cancel();
                    break;
                }
                case FastClock: {
                    if (this._fastClock == null) break;
                    this._fastClock.removePropertyChangeListener("time", this);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("_type has unknown value: " + this._type.name());
                }
            }
            this._listenersAreRegistered = false;
        }
    }

    private void scheduleTimer() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                TimeSinceMidnight.this.propertyChange(null);
            }
        };
        TimerUtil.schedule(this.timerTask, System.currentTimeMillis() % 60000L, 60000L);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    public static enum Type {
        FastClock(Bundle.getMessage("ClockTypeFastClock")),
        SystemClock(Bundle.getMessage("ClockTypeSystemClock"));

        private final String _text;

        private Type(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

