/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.expressions.AbstractStringExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringExpressionConstant
extends AbstractStringExpression {
    private String _value = "";
    private static final Logger log = LoggerFactory.getLogger(StringExpressionConstant.class);

    public StringExpressionConstant(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        StringExpressionManager manager = InstanceManager.getDefault(StringExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        StringExpressionConstant copy = new StringExpressionConstant(sysName, userName);
        copy.setComment(this.getComment());
        copy.setValue(this._value);
        return manager.registerExpression(copy);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public void setValue(String value) {
        this.assertListenersAreNotRegistered(log, "setValue");
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public String evaluate() {
        return this._value;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "StringExpressionConstant_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._value == null) {
            return Bundle.getMessage(locale, "StringExpressionConstant_LongNull");
        }
        return Bundle.getMessage(locale, "StringExpressionConstant_LongValue", this._value);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }
}

