/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Not
extends AbstractDigitalExpression
implements FemaleSocketListener {
    private String _socketSystemName;
    private final FemaleDigitalExpressionSocket _socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("Not_SocketName"));
    private static final Logger log = LoggerFactory.getLogger(Not.class);

    public Not(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Not copy = new Not(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public boolean evaluate() throws JmriException {
        return !this._socket.evaluate();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Not_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Not_Long");
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    this._socket.disconnect();
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

