/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.script.ScriptOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogData
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private boolean _result = false;
    private boolean _logToLog = true;
    private boolean _logToScriptOutput = false;
    private FormatType _formatType = FormatType.OnlyText;
    private String _format = "";
    private final List<Data> _dataList = new ArrayList<Data>();
    private static final Logger log = LoggerFactory.getLogger(LogData.class);

    public LogData(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        LogData copy = new LogData(sysName, userName);
        copy.setComment(this.getComment());
        copy.setLogToLog(this._logToLog);
        copy.setLogToScriptOutput(this._logToScriptOutput);
        copy.setFormat(this._format);
        copy.setFormatType(this._formatType);
        for (Data data : this._dataList) {
            copy.getDataList().add(new Data(data));
        }
        return manager.registerExpression(copy);
    }

    public void setResult(boolean result) {
        this._result = result;
    }

    public boolean getResult() {
        return this._result;
    }

    public void setLogToLog(boolean logToLog) {
        this._logToLog = logToLog;
    }

    public boolean getLogToLog() {
        return this._logToLog;
    }

    public void setLogToScriptOutput(boolean logToScriptOutput) {
        this._logToScriptOutput = logToScriptOutput;
    }

    public boolean getLogToScriptOutput() {
        return this._logToScriptOutput;
    }

    public void setFormatType(FormatType formatType) {
        this._formatType = formatType;
    }

    public FormatType getFormatType() {
        return this._formatType;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getFormat() {
        return this._format;
    }

    public List<Data> getDataList() {
        return this._dataList;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    private List<Object> getDataValues() throws JmriException {
        ArrayList<Object> values = new ArrayList<Object>();
        block6: for (Data _data : this._dataList) {
            switch (_data._dataType) {
                case LocalVariable: {
                    values.add(this.getConditionalNG().getSymbolTable().getValue(_data._data));
                    break;
                }
                case Memory: {
                    MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
                    Memory memory = memoryManager.getMemory(_data._data);
                    if (memory == null) {
                        throw new IllegalArgumentException("Memory '" + _data._data + "' not found");
                    }
                    values.add(memory.getValue());
                    break;
                }
                case Reference: {
                    values.add(ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), _data._data));
                    break;
                }
                case Formula: {
                    if (_data._expressionNode == null) continue block6;
                    values.add(_data._expressionNode.calculate(this.getConditionalNG().getSymbolTable()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("_formatType has invalid value: " + this._formatType.name());
                }
            }
        }
        return values;
    }

    @Override
    public boolean evaluate() throws JmriException {
        String str;
        switch (this._formatType) {
            case OnlyText: {
                str = this._format;
                break;
            }
            case CommaSeparatedList: {
                StringBuilder sb = new StringBuilder();
                for (Object value : this.getDataValues()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(value != null ? value.toString() : "null");
                }
                str = sb.toString();
                break;
            }
            case StringFormat: {
                str = String.format(this._format, this.getDataValues().toArray());
                break;
            }
            default: {
                throw new IllegalArgumentException("_formatType has invalid value: " + this._formatType.name());
            }
        }
        if (this._logToLog) {
            log.warn(str);
        }
        if (this._logToScriptOutput) {
            ScriptOutput.getDefault().getOutputArea().append(String.valueOf(str) + "\n");
        }
        return this._result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "LogData_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "LogData_Long");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    public static class Data {
        private DataType _dataType = DataType.LocalVariable;
        private String _data = "";
        private ExpressionNode _expressionNode;

        public Data(Data data) throws ParserException {
            this._dataType = data._dataType;
            this._data = data._data;
            this.calculateFormula();
        }

        public Data(DataType dataType, String data) throws ParserException {
            this._dataType = dataType;
            this._data = data;
            this.calculateFormula();
        }

        private void calculateFormula() throws ParserException {
            if (this._dataType == DataType.Formula) {
                HashMap<String, Variable> variables = new HashMap<String, Variable>();
                RecursiveDescentParser parser = new RecursiveDescentParser(variables);
                this._expressionNode = parser.parseExpression(this._data);
            } else {
                this._expressionNode = null;
            }
        }

        public void setDataType(DataType dataType) {
            this._dataType = dataType;
        }

        public DataType getDataType() {
            return this._dataType;
        }

        public void setData(String data) {
            this._data = data;
        }

        public String getData() {
            return this._data;
        }
    }

    public static enum DataType {
        LocalVariable(Bundle.getMessage("LogData_Operation_LocalVariable")),
        Memory(Bundle.getMessage("LogData_Operation_Memory")),
        Reference(Bundle.getMessage("LogData_Operation_Reference")),
        Formula(Bundle.getMessage("LogData_Operation_Formula"));

        private final String _text;

        private DataType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum FormatType {
        OnlyText(Bundle.getMessage("LogData_FormatType_TextOnly"), true, false),
        CommaSeparatedList(Bundle.getMessage("LogData_FormatType_CommaSeparatedList"), false, true),
        StringFormat(Bundle.getMessage("LogData_FormatType_StringFormat"), true, true);

        private final String _text;
        private final boolean _useFormat;
        private final boolean _useData;

        private FormatType(String text, boolean useFormat, boolean useData) {
            this._text = text;
            this._useFormat = useFormat;
            this._useData = useData;
        }

        public String toString() {
            return this._text;
        }

        public boolean getUseFormat() {
            return this._useFormat;
        }

        public boolean getUseData() {
            return this._useData;
        }
    }
}

