/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpression;
import jmri.jmrit.logixng.DigitalExpressionBean;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastResultOfDigitalExpression
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanHandle<DigitalExpressionBean> _digitalExpressionHandle;
    private static final Logger log = LoggerFactory.getLogger(LastResultOfDigitalExpression.class);

    public LastResultOfDigitalExpression(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        LastResultOfDigitalExpression copy = new LastResultOfDigitalExpression(sysName, userName);
        copy.setComment(this.getComment());
        if (this._digitalExpressionHandle != null) {
            copy.setDigitalExpression(this._digitalExpressionHandle);
        }
        return manager.registerExpression(copy);
    }

    public void setDigitalExpression(@Nonnull String digitalExpressionName) {
        this.assertListenersAreNotRegistered(log, "setDigitalExpression");
        DigitalExpressionBean digitalExpression = (DigitalExpressionBean)InstanceManager.getDefault(DigitalExpressionManager.class).getNamedBean(digitalExpressionName);
        if (digitalExpression != null) {
            if (!(digitalExpression instanceof MaleSocket)) {
                digitalExpression = (DigitalExpressionBean)digitalExpression.getParent();
            }
            this.setDigitalExpression(digitalExpression);
        } else {
            this.removeDigitalExpression();
            log.error("digitalExpression \"{}\" is not found", (Object)digitalExpressionName);
        }
    }

    public void setDigitalExpression(@Nonnull NamedBeanHandle<DigitalExpressionBean> handle) {
        this.assertListenersAreNotRegistered(log, "setDigitalExpression");
        this._digitalExpressionHandle = handle;
        InstanceManager.getDefault(DigitalExpressionManager.class).addVetoableChangeListener(this);
    }

    public void setDigitalExpression(@Nonnull DigitalExpressionBean digitalExpression) {
        this.assertListenersAreNotRegistered(log, "setDigitalExpression");
        this.setDigitalExpression(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(digitalExpression.getDisplayName(), digitalExpression));
    }

    public void removeDigitalExpression() {
        this.assertListenersAreNotRegistered(log, "setDigitalExpression");
        if (this._digitalExpressionHandle != null) {
            InstanceManager.getDefault(DigitalExpressionManager.class).removeVetoableChangeListener(this);
            this._digitalExpressionHandle = null;
        }
    }

    public NamedBeanHandle<DigitalExpressionBean> getDigitalExpression() {
        return this._digitalExpressionHandle;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof DigitalExpression && evt.getOldValue().equals(this.getDigitalExpression().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("LastResultOfDigitalExpression_BeanInUseVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof DigitalExpression && evt.getOldValue().equals(this.getDigitalExpression().getBean())) {
            this.removeDigitalExpression();
        }
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public boolean evaluate() {
        if (this._digitalExpressionHandle != null) {
            MaleSocket m = (MaleSocket)((Object)this._digitalExpressionHandle.getBean());
            while (m != null && !(m instanceof MaleDigitalExpressionSocket)) {
                m = (MaleSocket)m.getObject();
            }
            if (m == null) {
                throw new RuntimeException("The digital expression " + this._digitalExpressionHandle.getName() + " is not contained in a DigitalExpressionSocket");
            }
            return ((MaleDigitalExpressionSocket)m).getLastResult();
        }
        return false;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "LastResultOfDigitalExpression_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String beanName = this._digitalExpressionHandle != null ? this._digitalExpressionHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
        return Bundle.getMessage(locale, "LastResultOfDigitalExpression_Long", beanName);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._digitalExpressionHandle != null) {
            this._digitalExpressionHandle.getBean().addPropertyChangeListener("LastResultChanged", this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._digitalExpressionHandle.getBean().removePropertyChangeListener("LastResultChanged", this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }
}

