/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionWarrant
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Warrant> _warrantHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private WarrantState _warrantState = WarrantState.RouteAllocated;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ExpressionWarrant.class);

    public ExpressionWarrant(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionWarrant copy = new ExpressionWarrant(sysName, userName);
        copy.setComment(this.getComment());
        if (this._warrantHandle != null) {
            copy.setWarrant(this._warrantHandle);
        }
        copy.setBeanState(this._warrantState);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setStateAddressing(this._stateAddressing);
        copy.setStateFormula(this._stateFormula);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateReference(this._stateReference);
        return manager.registerExpression(copy);
    }

    public void setWarrant(@Nonnull String warrantName) {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        Warrant warrant = InstanceManager.getDefault(WarrantManager.class).getWarrant(warrantName);
        if (warrant != null) {
            this.setWarrant(warrant);
        } else {
            this.removeWarrant();
            log.warn("warrant \"{}\" is not found", (Object)warrantName);
        }
    }

    public void setWarrant(@Nonnull NamedBeanHandle<Warrant> handle) {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        this._warrantHandle = handle;
        InstanceManager.getDefault(WarrantManager.class).addVetoableChangeListener(this);
    }

    public void setWarrant(@Nonnull Warrant warrant) {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        this.setWarrant(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(warrant.getDisplayName(), warrant));
    }

    public void removeWarrant() {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        if (this._warrantHandle != null) {
            InstanceManager.getDefault(WarrantManager.class).removeVetoableChangeListener(this);
            this._warrantHandle = null;
        }
    }

    public NamedBeanHandle<Warrant> getWarrant() {
        return this._warrantHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setBeanState(WarrantState state) {
        this._warrantState = state;
    }

    public WarrantState getBeanState() {
        return this._warrantState;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Warrant && evt.getOldValue().equals(this.getWarrant().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("Warrant_WarrantInUseWarrantExpressionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Warrant && evt.getOldValue().equals(this.getWarrant().getBean())) {
            this.removeWarrant();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result;
        Warrant warrant;
        switch (this._addressing) {
            case Direct: {
                warrant = this._warrantHandle != null ? this._warrantHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                warrant = (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                warrant = (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                warrant = this._expressionNode != null ? (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (warrant == null) {
            return false;
        }
        WarrantState checkWarrantState = this._stateAddressing == NamedBeanAddressing.Direct ? this._warrantState : WarrantState.valueOf(this.getNewState());
        switch (checkWarrantState) {
            case RouteFree: {
                result = warrant.routeIsFree();
                break;
            }
            case RouteOccupied: {
                result = warrant.routeIsOccupied();
                break;
            }
            case RouteAllocated: {
                result = warrant.isAllocated();
                break;
            }
            case RouteSet: {
                result = warrant.hasRouteSet();
                break;
            }
            case TrainRunning: {
                result = warrant.getRunMode() != 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("checkWarrantState has unknown value: " + checkWarrantState.name());
            }
        }
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return result;
        }
        return !result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Warrant_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String warrantName = this._warrantHandle != null ? this._warrantHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", warrantName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._stateAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._warrantState._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "Warrant_Long", namedBean, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._warrantHandle != null) {
            this._warrantHandle.getBean().addPropertyChangeListener("KnownState", this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._warrantHandle.getBean().removePropertyChangeListener("KnownState", this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionWarrant: bean = {}, report = {}", (Object)cdl, report);
        if (this.getWarrant() != null && bean.equals(this.getWarrant().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
    }

    public static enum WarrantState {
        RouteFree(Bundle.getMessage("WarrantTypeRouteFree")),
        RouteOccupied(Bundle.getMessage("WarrantTypeOccupied")),
        RouteAllocated(Bundle.getMessage("WarrantTypeAllocated")),
        RouteSet(Bundle.getMessage("WarrantTypeRouteSet")),
        TrainRunning(Bundle.getMessage("WarrantTypeTrainRunning"));

        private final String _text;

        private WarrantState(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

