/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSignalHead
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<SignalHead> _signalHeadHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _queryAddressing = NamedBeanAddressing.Direct;
    private QueryType _queryType = QueryType.Appearance;
    private String _queryReference = "";
    private String _queryLocalVariable = "";
    private String _queryFormula = "";
    private ExpressionNode _queryExpressionNode;
    private NamedBeanAddressing _appearanceAddressing = NamedBeanAddressing.Direct;
    private int _signalHeadAppearance = 0;
    private String _appearanceReference = "";
    private String _appearanceLocalVariable = "";
    private String _appearanceFormula = "";
    private ExpressionNode _appearanceExpressionNode;
    private NamedBeanHandle<SignalHead> _exampleSignalHeadHandle;
    private static final Logger log = LoggerFactory.getLogger(ExpressionSignalHead.class);

    public ExpressionSignalHead(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionSignalHead copy = new ExpressionSignalHead(sysName, userName);
        copy.setComment(this.getComment());
        if (this._signalHeadHandle != null) {
            copy.setSignalHead(this._signalHeadHandle);
        }
        copy.setAppearance(this._signalHeadAppearance);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setQueryAddressing(this._queryAddressing);
        copy.setQueryType(this._queryType);
        copy.setQueryFormula(this._queryFormula);
        copy.setQueryLocalVariable(this._queryLocalVariable);
        copy.setQueryReference(this._queryReference);
        copy.setAppearanceAddressing(this._appearanceAddressing);
        copy.setAppearanceFormula(this._appearanceFormula);
        copy.setAppearanceLocalVariable(this._appearanceLocalVariable);
        copy.setAppearanceReference(this._appearanceReference);
        copy.setExampleSignalHead(this._exampleSignalHeadHandle);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setSignalHead(@Nonnull String signalHeadName) {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        if (signalHead != null) {
            this.setSignalHead(signalHead);
        } else {
            this.removeSignalHead();
            log.error("signalHead \"{}\" is not found", (Object)signalHeadName);
        }
    }

    public void setSignalHead(@Nonnull NamedBeanHandle<SignalHead> handle) {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        this._signalHeadHandle = handle;
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
    }

    public void setSignalHead(@Nonnull SignalHead signalHead) {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        this.setSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead.getDisplayName(), signalHead));
    }

    public void removeSignalHead() {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        if (this._signalHeadHandle != null) {
            InstanceManager.getDefault(SignalHeadManager.class).removeVetoableChangeListener(this);
            this._signalHeadHandle = null;
        }
    }

    public NamedBeanHandle<SignalHead> getSignalHead() {
        return this._signalHeadHandle;
    }

    public void setExampleSignalHead(@Nonnull String signalHeadName) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalHead");
        SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        if (signalHead != null) {
            this.setExampleSignalHead(signalHead);
        } else {
            this.removeExampleSignalHead();
            log.error("signalHead \"{}\" is not found", (Object)signalHeadName);
        }
    }

    public void setExampleSignalHead(@Nonnull NamedBeanHandle<SignalHead> handle) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalHead");
        this._exampleSignalHeadHandle = handle;
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
    }

    public void setExampleSignalHead(@Nonnull SignalHead signalHead) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalHead");
        this.setExampleSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead.getDisplayName(), signalHead));
    }

    public void removeExampleSignalHead() {
        this.assertListenersAreNotRegistered(log, "removeExampleSignalHead");
        if (this._exampleSignalHeadHandle != null) {
            InstanceManager.getDefault(SignalHeadManager.class).removeVetoableChangeListener(this);
            this._exampleSignalHeadHandle = null;
        }
    }

    public NamedBeanHandle<SignalHead> getExampleSignalHead() {
        return this._exampleSignalHeadHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setQueryAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._queryAddressing = addressing;
        this.parseQueryFormula();
    }

    public NamedBeanAddressing getQueryAddressing() {
        return this._queryAddressing;
    }

    public void setQueryType(QueryType queryType) {
        this._queryType = queryType;
    }

    public QueryType getQueryType() {
        return this._queryType;
    }

    public void setQueryReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._queryReference = reference;
    }

    public String getQueryReference() {
        return this._queryReference;
    }

    public void setQueryLocalVariable(@Nonnull String localVariable) {
        this._queryLocalVariable = localVariable;
    }

    public String getQueryLocalVariable() {
        return this._queryLocalVariable;
    }

    public void setQueryFormula(@Nonnull String formula) throws ParserException {
        this._queryFormula = formula;
        this.parseQueryFormula();
    }

    public String getQueryFormula() {
        return this._queryFormula;
    }

    private void parseQueryFormula() throws ParserException {
        if (this._queryAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._queryExpressionNode = parser.parseExpression(this._queryFormula);
        } else {
            this._queryExpressionNode = null;
        }
    }

    public void setAppearanceAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._appearanceAddressing = addressing;
        this.parseAppearanceFormula();
    }

    public NamedBeanAddressing getAppearanceAddressing() {
        return this._appearanceAddressing;
    }

    public void setAppearance(int appearance) {
        this._signalHeadAppearance = appearance;
    }

    public int getAppearance() {
        return this._signalHeadAppearance;
    }

    public void setAppearanceReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._appearanceReference = reference;
    }

    public String getAppearanceReference() {
        return this._appearanceReference;
    }

    public void setAppearanceLocalVariable(@Nonnull String localVariable) {
        this._appearanceLocalVariable = localVariable;
    }

    public String getAppearanceLocalVariable() {
        return this._appearanceLocalVariable;
    }

    public void setAppearanceFormula(@Nonnull String formula) throws ParserException {
        this._appearanceFormula = formula;
        this.parseAppearanceFormula();
    }

    public String getAppearanceFormula() {
        return this._appearanceFormula;
    }

    private void parseAppearanceFormula() throws ParserException {
        if (this._appearanceAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._appearanceExpressionNode = parser.parseExpression(this._appearanceFormula);
        } else {
            this._appearanceExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof SignalHead) {
                if (this._signalHeadHandle != null && evt.getOldValue().equals(this._signalHeadHandle.getBean())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("SignalHead_SignalHeadInUseSignalHeadExpressionVeto", this.getDisplayName()), e);
                }
                if (this._exampleSignalHeadHandle != null && evt.getOldValue().equals(this._exampleSignalHeadHandle.getBean())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("SignalHead_SignalHeadInUseSignalHeadExpressionVeto", this.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof SignalHead) {
            if (this._signalHeadHandle != null && evt.getOldValue().equals(this._signalHeadHandle.getBean())) {
                this.removeSignalHead();
            }
            if (this._exampleSignalHeadHandle != null && evt.getOldValue().equals(this._exampleSignalHeadHandle.getBean())) {
                this.removeExampleSignalHead();
            }
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private int getAppearanceFromName(String name) {
        if (this._signalHeadHandle == null) {
            throw new UnsupportedOperationException("_signalHeadHandle is null");
        }
        SignalHead sh = this._signalHeadHandle.getBean();
        String[] keys = sh.getValidStateKeys();
        int i = 0;
        while (i < keys.length) {
            if (name.equals(keys[i])) {
                return sh.getValidStates()[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Appearance " + name + " is not valid for signal head " + sh.getSystemName());
    }

    private int getNewAppearance() throws JmriException {
        switch (this._appearanceAddressing) {
            case Direct: {
                return this._signalHeadAppearance;
            }
            case Reference: {
                return this.getAppearanceFromName(ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._appearanceReference));
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return this.getAppearanceFromName(TypeConversionUtil.convertToString(symbolTable.getValue(this._appearanceLocalVariable), false));
            }
            case Formula: {
                return this._appearanceExpressionNode != null ? this.getAppearanceFromName(TypeConversionUtil.convertToString(this._appearanceExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : -1;
            }
        }
        throw new IllegalArgumentException("invalid _aspectAddressing state: " + this._appearanceAddressing.name());
    }

    private QueryType getQuery() throws JmriException {
        String oper = "";
        try {
            switch (this._queryAddressing) {
                case Direct: {
                    return this._queryType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._queryReference);
                    return QueryType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._queryLocalVariable), false);
                    return QueryType.valueOf(oper);
                }
                case Formula: {
                    if (this._appearanceExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._queryExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false);
                        return QueryType.valueOf(oper);
                    }
                    return null;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown query: " + oper, e);
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._queryAddressing.name());
    }

    @Override
    public boolean evaluate() throws JmriException {
        SignalHead signalHead;
        switch (this._addressing) {
            case Direct: {
                signalHead = this._signalHeadHandle != null ? this._signalHeadHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                signalHead = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                signalHead = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                signalHead = this._expressionNode != null ? (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (signalHead == null) {
            return false;
        }
        QueryType query = this.getQuery();
        boolean result = false;
        switch (query) {
            case Appearance: {
                int queryAppearance = this.getNewAppearance();
                if (queryAppearance == -1) break;
                result = signalHead.getAppearance() == queryAppearance;
                break;
            }
            case NotAppearance: {
                int queryAppearance = this.getNewAppearance();
                if (queryAppearance == -1) break;
                result = signalHead.getAppearance() != queryAppearance;
                break;
            }
            case Lit: {
                result = signalHead.getLit();
                break;
            }
            case NotLit: {
                result = !signalHead.getLit();
                break;
            }
            case Held: {
                result = signalHead.getHeld();
                break;
            }
            case NotHeld: {
                result = !signalHead.getHeld();
                break;
            }
            default: {
                throw new RuntimeException("Unknown enum: " + this._queryType.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SignalHead_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String appearance;
        String query;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String sensorName = this._signalHeadHandle != null ? this._signalHeadHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", sensorName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._queryAddressing) {
            case Direct: {
                query = Bundle.getMessage(locale, "AddressByDirect", this._queryType._text);
                break;
            }
            case Reference: {
                query = Bundle.getMessage(locale, "AddressByReference", this._queryReference);
                break;
            }
            case LocalVariable: {
                query = Bundle.getMessage(locale, "AddressByLocalVariable", this._queryLocalVariable);
                break;
            }
            case Formula: {
                query = Bundle.getMessage(locale, "AddressByFormula", this._queryFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _queryAddressing state: " + this._queryAddressing.name());
            }
        }
        switch (this._appearanceAddressing) {
            case Direct: {
                String a = "";
                if (this._signalHeadHandle != null && this._signalHeadHandle.getBean() != null) {
                    a = this._signalHeadHandle.getBean().getAppearanceName(this._signalHeadAppearance);
                }
                appearance = Bundle.getMessage(locale, "AddressByDirect", a);
                break;
            }
            case Reference: {
                appearance = Bundle.getMessage(locale, "AddressByReference", this._appearanceReference);
                break;
            }
            case LocalVariable: {
                appearance = Bundle.getMessage(locale, "AddressByLocalVariable", this._appearanceLocalVariable);
                break;
            }
            case Formula: {
                appearance = Bundle.getMessage(locale, "AddressByFormula", this._appearanceFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._appearanceAddressing.name());
            }
        }
        if (this._queryAddressing == NamedBeanAddressing.Direct) {
            if (this._queryType == QueryType.Appearance) {
                return Bundle.getMessage(locale, "SignalHead_LongAppearance", namedBean, appearance);
            }
            if (this._queryType == QueryType.NotAppearance) {
                return Bundle.getMessage(locale, "SignalHead_LongNotAppearance", namedBean, appearance);
            }
            return Bundle.getMessage(locale, "SignalHead_Long", namedBean, query);
        }
        return Bundle.getMessage(locale, "SignalHead_LongUnknownOper", namedBean, query, appearance);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._signalHeadHandle != null) {
            switch (this._queryType) {
                case Appearance: 
                case NotAppearance: {
                    this._signalHeadHandle.getBean().addPropertyChangeListener("Appearance", this);
                    break;
                }
                case Lit: 
                case NotLit: {
                    this._signalHeadHandle.getBean().addPropertyChangeListener("Lit", this);
                    break;
                }
                case Held: 
                case NotHeld: {
                    this._signalHeadHandle.getBean().addPropertyChangeListener("Held", this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown enum: " + this._queryType.name());
                }
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            switch (this._queryType) {
                case Appearance: 
                case NotAppearance: {
                    this._signalHeadHandle.getBean().removePropertyChangeListener("Appearance", this);
                    break;
                }
                case Lit: 
                case NotLit: {
                    this._signalHeadHandle.getBean().removePropertyChangeListener("Lit", this);
                    break;
                }
                case Held: 
                case NotHeld: {
                    this._signalHeadHandle.getBean().removePropertyChangeListener("Held", this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown enum: " + this._queryType.name());
                }
            }
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionSignalHead: bean = {}, report = {}", (Object)cdl, report);
        if (this.getSignalHead() != null && bean.equals(this.getSignalHead().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
        if (this.getExampleSignalHead() != null && bean.equals(this.getExampleSignalHead().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
    }

    public static enum QueryType {
        Appearance(Bundle.getMessage("SignalHeadQueryType_Appearance")),
        NotAppearance(Bundle.getMessage("SignalHeadQueryType_NotAppearance")),
        Lit(Bundle.getMessage("SignalHeadQueryType_Lit")),
        NotLit(Bundle.getMessage("SignalHeadQueryType_NotLit")),
        Held(Bundle.getMessage("SignalHeadQueryType_Held")),
        NotHeld(Bundle.getMessage("SignalHeadQueryType_NotHeld"));

        private final String _text;

        private QueryType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

