/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LightManager;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionReference
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private String _reference;
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private PointsTo _pointsTo = PointsTo.Nothing;
    private static final Logger log = LoggerFactory.getLogger(ExpressionReference.class);

    public ExpressionReference(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionReference copy = new ExpressionReference(sysName, userName);
        copy.setComment(this.getComment());
        copy.setReference(this._reference);
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setPointsTo(this._pointsTo);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setReference(String reference) {
        this.assertListenersAreNotRegistered(log, "setReference");
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setPointsTo(PointsTo pointsTo) {
        this._pointsTo = pointsTo;
    }

    public PointsTo getPointsTo() {
        return this._pointsTo;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public boolean evaluate() {
        boolean result;
        if (this._reference == null) {
            return false;
        }
        String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
        switch (this._pointsTo) {
            case Nothing: {
                result = "".equals(ref);
                break;
            }
            case LogixNGTable: {
                Object t = InstanceManager.getDefault(NamedTableManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case Audio: {
                Object t = InstanceManager.getDefault(AudioManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case Light: {
                Object t = InstanceManager.getDefault(LightManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case Memory: {
                Object t = InstanceManager.getDefault(MemoryManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case Sensor: {
                Object t = InstanceManager.getDefault(SensorManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case SignalHead: {
                Object t = InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case SignalMast: {
                Object t = InstanceManager.getDefault(SignalMastManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            case Turnout: {
                Object t = InstanceManager.getDefault(TurnoutManager.class).getNamedBean(ref);
                result = t != null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("_pointsTo has unknown value: " + this._pointsTo.name());
            }
        }
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return result;
        }
        return !result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Reference_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String reference = this._reference != null ? this._reference : Bundle.getMessage(locale, "ReferenceNotSelected");
        return Bundle.getMessage(locale, "Reference_Long", reference.isEmpty() ? "''" : reference, this._is_IsNot.toString(), this._pointsTo._text);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._reference != null) {
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static enum PointsTo {
        Nothing(Bundle.getMessage("ReferencePointsTo_Nothing")),
        Audio(Bundle.getMessage("ReferencePointsTo_Audio")),
        Light(Bundle.getMessage("ReferencePointsTo_Light")),
        Memory(Bundle.getMessage("ReferencePointsTo_Memory")),
        Sensor(Bundle.getMessage("ReferencePointsTo_Sensor")),
        SignalHead(Bundle.getMessage("ReferencePointsTo_SignalHead")),
        SignalMast(Bundle.getMessage("ReferencePointsTo_SignalMast")),
        Turnout(Bundle.getMessage("ReferencePointsTo_Turnout")),
        LogixNGTable(Bundle.getMessage("ReferencePointsTo_LogixNGTable"));

        private final String _text;

        private PointsTo(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

