/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionMemory
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanHandle<Memory> _memoryHandle;
    private MemoryOperation _memoryOperation = MemoryOperation.Equal;
    private CompareTo _compareTo = CompareTo.Value;
    private boolean _caseInsensitive = false;
    private String _constantValue = "";
    private NamedBeanHandle<Memory> _otherMemoryHandle;
    private String _localVariable = "";
    private String _regEx = "";
    private boolean _listenToOtherMemory = true;
    private static final Logger log = LoggerFactory.getLogger(ExpressionMemory.class);

    public ExpressionMemory(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionMemory copy = new ExpressionMemory(sysName, userName);
        copy.setComment(this.getComment());
        if (this._memoryHandle != null) {
            copy.setMemory(this._memoryHandle);
        }
        copy.setMemoryOperation(this._memoryOperation);
        copy.setCompareTo(this._compareTo);
        copy.setCaseInsensitive(this._caseInsensitive);
        copy.setConstantValue(this._constantValue);
        if (this._otherMemoryHandle != null) {
            copy.setOtherMemory(this._otherMemoryHandle);
        }
        copy.setListenToOtherMemory(this._listenToOtherMemory);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this._memoryHandle = handle;
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
        this.addRemoveVetoListener();
    }

    public void setMemory(@Nonnull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeMemory() {
        this.assertListenersAreNotRegistered(log, "removeMemory");
        if (this._memoryHandle != null) {
            this._memoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setOtherMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setOtherMemory");
        MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
        Memory memory = memoryManager.getMemory(memoryName);
        if (memory != null) {
            this.setOtherMemory(memory);
        } else {
            this.removeOtherMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setOtherMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setOtherMemory");
        this._otherMemoryHandle = handle;
        this.addRemoveVetoListener();
    }

    public void setOtherMemory(@Nonnull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setOtherMemory");
        this.setOtherMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeOtherMemory() {
        this.assertListenersAreNotRegistered(log, "removeOtherMemory");
        if (this._otherMemoryHandle != null) {
            this._otherMemoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getOtherMemory() {
        return this._otherMemoryHandle;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setConstantValue(String constantValue) {
        this._constantValue = constantValue;
    }

    public String getConstantValue() {
        return this._constantValue;
    }

    public void setRegEx(String regEx) {
        this._regEx = regEx;
    }

    public String getRegEx() {
        return this._regEx;
    }

    public void setListenToOtherMemory(boolean listenToOtherMemory) {
        this._listenToOtherMemory = listenToOtherMemory;
    }

    public boolean getListenToOtherMemory() {
        return this._listenToOtherMemory;
    }

    public void setMemoryOperation(MemoryOperation memoryOperation) {
        this._memoryOperation = memoryOperation;
    }

    public MemoryOperation getMemoryOperation() {
        return this._memoryOperation;
    }

    public void setCompareTo(CompareTo compareTo) {
        this._compareTo = compareTo;
    }

    public CompareTo getCompareTo() {
        return this._compareTo;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public boolean getCaseInsensitive() {
        return this._caseInsensitive;
    }

    private void addRemoveVetoListener() {
        if (this._memoryHandle != null || this._otherMemoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Memory) {
                boolean doVeto = false;
                if (this._memoryHandle != null && evt.getOldValue().equals(this._memoryHandle.getBean())) {
                    doVeto = true;
                }
                if (this._otherMemoryHandle != null && evt.getOldValue().equals(this._otherMemoryHandle.getBean())) {
                    doVeto = true;
                }
                if (doVeto) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("Memory_MemoryInUseMemoryExpressionVeto", this.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Memory) {
            if (evt.getOldValue().equals(this._memoryHandle.getBean())) {
                this.removeMemory();
            }
            if (this._otherMemoryHandle != null && evt.getOldValue().equals(this._otherMemoryHandle.getBean())) {
                this.removeOtherMemory();
            }
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private boolean compare(String value1, String value2, boolean caseInsensitive) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        value1 = value1.trim();
        value2 = value2.trim();
        try {
            int n1 = Integer.parseInt(value1);
            try {
                int n2 = Integer.parseInt(value2);
                log.debug("Compare numbers: n1= {} to n2= {}", (Object)n1, (Object)n2);
                switch (this._memoryOperation) {
                    case LessThan: {
                        return n1 < n2;
                    }
                    case LessThanOrEqual: {
                        return n1 <= n2;
                    }
                    case Equal: {
                        return n1 == n2;
                    }
                    case NotEqual: {
                        return n1 != n2;
                    }
                    case GreaterThanOrEqual: {
                        return n1 >= n2;
                    }
                    case GreaterThan: {
                        return n1 > n2;
                    }
                }
                throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._memoryOperation.name());
            }
            catch (NumberFormatException numberFormatException) {
                return this._memoryOperation == MemoryOperation.NotEqual;
            }
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Integer.parseInt(value2);
                return this._memoryOperation == MemoryOperation.NotEqual;
            }
            catch (NumberFormatException numberFormatException2) {
                log.debug("Compare Strings: value1= {} to value2= {}", (Object)value1, (Object)value2);
                int compare = caseInsensitive ? value1.compareToIgnoreCase(value2) : value1.compareTo(value2);
                switch (this._memoryOperation) {
                    case LessThan: {
                        if (compare >= 0) break;
                        return true;
                    }
                    case LessThanOrEqual: {
                        if (compare > 0) break;
                        return true;
                    }
                    case Equal: {
                        if (compare != 0) break;
                        return true;
                    }
                    case NotEqual: {
                        if (compare == 0) break;
                        return true;
                    }
                    case GreaterThanOrEqual: {
                        if (compare < 0) break;
                        return true;
                    }
                    case GreaterThan: {
                        if (compare <= 0) break;
                        return true;
                    }
                    default: {
                        throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._memoryOperation.name());
                    }
                }
                return false;
            }
        }
    }

    private boolean matchRegex(String memoryValue, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(memoryValue);
        return m.matches();
    }

    @Override
    public boolean evaluate() {
        boolean result;
        if (this._memoryHandle == null) {
            return false;
        }
        String memoryValue = this.getString(this._memoryHandle.getBean().getValue());
        String otherValue = null;
        switch (this._compareTo) {
            case Value: {
                otherValue = this._constantValue;
                break;
            }
            case Memory: {
                otherValue = this.getString(this._otherMemoryHandle.getBean().getValue());
                break;
            }
            case LocalVariable: {
                otherValue = TypeConversionUtil.convertToString(this.getConditionalNG().getSymbolTable().getValue(this._localVariable), false);
                break;
            }
            case RegEx: {
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._memoryOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case GreaterThanOrEqual: 
            case GreaterThan: 
            case NotEqual: {
                result = this.compare(memoryValue, otherValue, this._caseInsensitive);
                break;
            }
            case IsNull: {
                result = memoryValue == null;
                break;
            }
            case IsNotNull: {
                result = memoryValue != null;
                break;
            }
            case MatchRegex: {
                result = this.matchRegex(memoryValue, this._regEx);
                break;
            }
            case NotMatchRegex: {
                result = !this.matchRegex(memoryValue, this._regEx);
                break;
            }
            default: {
                throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._memoryOperation.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Memory_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String other;
        String message;
        String memoryName = this._memoryHandle != null ? this._memoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        String otherMemoryName = this._otherMemoryHandle != null ? this._otherMemoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._compareTo) {
            case Value: {
                message = "Memory_Long_CompareConstant";
                other = this._constantValue;
                break;
            }
            case Memory: {
                message = "Memory_Long_CompareMemory";
                other = otherMemoryName;
                break;
            }
            case LocalVariable: {
                message = "Memory_Long_CompareLocalVariable";
                other = this._localVariable;
                break;
            }
            case RegEx: {
                message = "Memory_Long_CompareRegEx";
                other = this._regEx;
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._memoryOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case GreaterThanOrEqual: 
            case GreaterThan: 
            case NotEqual: {
                return Bundle.getMessage(locale, message, memoryName, this._memoryOperation._text, other);
            }
            case IsNull: 
            case IsNotNull: {
                return Bundle.getMessage(locale, "Memory_Long_CompareNull", memoryName, this._memoryOperation._text);
            }
            case MatchRegex: 
            case NotMatchRegex: {
                return Bundle.getMessage(locale, "Memory_Long_CompareRegEx", memoryName, this._memoryOperation._text, other);
            }
        }
        throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._memoryOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._memoryHandle != null) {
            this._memoryHandle.getBean().addPropertyChangeListener("value", this);
            if (this._listenToOtherMemory && this._otherMemoryHandle != null) {
                this._otherMemoryHandle.getBean().addPropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._memoryHandle.getBean().removePropertyChangeListener("value", this);
            if (this._listenToOtherMemory && this._otherMemoryHandle != null) {
                this._otherMemoryHandle.getBean().removePropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionMemory: bean = {}, report = {}", (Object)cdl, report);
        if (this.getMemory() != null && bean.equals(this.getMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
        if (this.getOtherMemory() != null && bean.equals(this.getOtherMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
    }

    public static enum CompareTo {
        Value(Bundle.getMessage("Memory_CompareTo_Value")),
        Memory(Bundle.getMessage("Memory_CompareTo_Memory")),
        LocalVariable(Bundle.getMessage("Memory_CompareTo_LocalVariable")),
        RegEx(Bundle.getMessage("Memory_CompareTo_RegularExpression"));

        private final String _text;

        private CompareTo(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum MemoryOperation {
        LessThan(Bundle.getMessage("MemoryOperation_LessThan"), true),
        LessThanOrEqual(Bundle.getMessage("MemoryOperation_LessThanOrEqual"), true),
        Equal(Bundle.getMessage("MemoryOperation_Equal"), true),
        GreaterThanOrEqual(Bundle.getMessage("MemoryOperation_GreaterThanOrEqual"), true),
        GreaterThan(Bundle.getMessage("MemoryOperation_GreaterThan"), true),
        NotEqual(Bundle.getMessage("MemoryOperation_NotEqual"), true),
        IsNull(Bundle.getMessage("MemoryOperation_IsNull"), false),
        IsNotNull(Bundle.getMessage("MemoryOperation_IsNotNull"), false),
        MatchRegex(Bundle.getMessage("MemoryOperation_MatchRegEx"), true),
        NotMatchRegex(Bundle.getMessage("MemoryOperation_NotMatchRegEx"), true);

        private final String _text;
        private final boolean _extraValue;

        private MemoryOperation(String text, boolean extraValue) {
            this._text = text;
            this._extraValue = extraValue;
        }

        public String toString() {
            return this._text;
        }

        public boolean hasExtraValue() {
            return this._extraValue;
        }
    }
}

