/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionLocalVariable
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private String _localVariable;
    private VariableOperation _variableOperation = VariableOperation.Equal;
    private CompareTo _compareTo = CompareTo.Value;
    private boolean _caseInsensitive = false;
    private String _constantValue = "";
    private NamedBeanHandle<Memory> _memoryHandle;
    private String _otherLocalVariable = "";
    private String _regEx = "";
    private boolean _listenToMemory = true;
    private static final Logger log = LoggerFactory.getLogger(ExpressionLocalVariable.class);

    public ExpressionLocalVariable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionLocalVariable copy = new ExpressionLocalVariable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setLocalVariable(this._localVariable);
        copy.setVariableOperation(this._variableOperation);
        copy.setCompareTo(this._compareTo);
        copy.setCaseInsensitive(this._caseInsensitive);
        copy.setConstantValue(this._constantValue);
        if (this._memoryHandle != null) {
            copy.setMemory(this._memoryHandle);
        }
        copy.setOtherLocalVariable(this._localVariable);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setLocalVariable(String variableName) {
        this.assertListenersAreNotRegistered(log, "setLocalVariable");
        this._localVariable = variableName;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
        Memory memory = memoryManager.getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.error("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this._memoryHandle = handle;
        if (this._memoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public void setMemory(@CheckForNull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        if (memory != null) {
            this._memoryHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            this._memoryHandle = null;
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public void removeMemory() {
        this.assertListenersAreNotRegistered(log, "removeMemory");
        if (this._memoryHandle != null) {
            InstanceManager.memoryManagerInstance().removeVetoableChangeListener(this);
            this._memoryHandle = null;
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public void setConstantValue(String constantValue) {
        this._constantValue = constantValue;
    }

    public String getConstantValue() {
        return this._constantValue;
    }

    public void setRegEx(String regEx) {
        this._regEx = regEx;
    }

    public String getRegEx() {
        return this._regEx;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setVariableOperation(VariableOperation variableOperation) {
        this._variableOperation = variableOperation;
    }

    public VariableOperation getVariableOperation() {
        return this._variableOperation;
    }

    public void setCompareTo(CompareTo compareTo) {
        this._compareTo = compareTo;
    }

    public CompareTo getCompareTo() {
        return this._compareTo;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public boolean getCaseInsensitive() {
        return this._caseInsensitive;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private boolean compare(String value1, String value2, boolean caseInsensitive) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        value1 = value1.trim();
        value2 = value2.trim();
        try {
            int n1 = Integer.parseInt(value1);
            try {
                int n2 = Integer.parseInt(value2);
                log.debug("Compare numbers: n1= {} to n2= {}", (Object)n1, (Object)n2);
                switch (this._variableOperation) {
                    case LessThan: {
                        return n1 < n2;
                    }
                    case LessThanOrEqual: {
                        return n1 <= n2;
                    }
                    case Equal: {
                        return n1 == n2;
                    }
                    case NotEqual: {
                        return n1 != n2;
                    }
                    case GreaterThanOrEqual: {
                        return n1 >= n2;
                    }
                    case GreaterThan: {
                        return n1 > n2;
                    }
                }
                throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._variableOperation.name());
            }
            catch (NumberFormatException numberFormatException) {
                return this._variableOperation == VariableOperation.NotEqual;
            }
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Integer.parseInt(value2);
                return this._variableOperation == VariableOperation.NotEqual;
            }
            catch (NumberFormatException numberFormatException2) {
                log.debug("Compare Strings: value1= {} to value2= {}", (Object)value1, (Object)value2);
                int compare = caseInsensitive ? value1.compareToIgnoreCase(value2) : value1.compareTo(value2);
                switch (this._variableOperation) {
                    case LessThan: {
                        if (compare >= 0) break;
                        return true;
                    }
                    case LessThanOrEqual: {
                        if (compare > 0) break;
                        return true;
                    }
                    case Equal: {
                        if (compare != 0) break;
                        return true;
                    }
                    case NotEqual: {
                        if (compare == 0) break;
                        return true;
                    }
                    case GreaterThanOrEqual: {
                        if (compare < 0) break;
                        return true;
                    }
                    case GreaterThan: {
                        if (compare <= 0) break;
                        return true;
                    }
                    default: {
                        throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._variableOperation.name());
                    }
                }
                return false;
            }
        }
    }

    private boolean matchRegex(String memoryValue, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(memoryValue);
        return m.matches();
    }

    @Override
    public boolean evaluate() {
        boolean result;
        if (this._localVariable == null) {
            return false;
        }
        String variableValue = this.getString(this.getConditionalNG().getSymbolTable().getValue(this._localVariable));
        String otherValue = null;
        switch (this._compareTo) {
            case Value: {
                otherValue = this._constantValue;
                break;
            }
            case Memory: {
                otherValue = this.getString(this._memoryHandle.getBean().getValue());
                break;
            }
            case LocalVariable: {
                otherValue = TypeConversionUtil.convertToString(this.getConditionalNG().getSymbolTable().getValue(this._otherLocalVariable), false);
                break;
            }
            case RegEx: {
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._variableOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case GreaterThanOrEqual: 
            case GreaterThan: 
            case NotEqual: {
                result = this.compare(variableValue, otherValue, this._caseInsensitive);
                break;
            }
            case IsNull: {
                result = variableValue == null;
                break;
            }
            case IsNotNull: {
                result = variableValue != null;
                break;
            }
            case MatchRegex: {
                result = this.matchRegex(variableValue, this._regEx);
                break;
            }
            case NotMatchRegex: {
                result = !this.matchRegex(variableValue, this._regEx);
                break;
            }
            default: {
                throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._variableOperation.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "LocalVariable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String other;
        String message;
        String variableName = this._localVariable == null || this._localVariable.isEmpty() ? Bundle.getMessage(locale, "BeanNotSelected") : this._localVariable;
        String memoryName = this._memoryHandle != null ? this._memoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._compareTo) {
            case Value: {
                message = "LocalVariable_Long_CompareConstant";
                other = this._constantValue;
                break;
            }
            case Memory: {
                message = "LocalVariable_Long_CompareMemory";
                other = memoryName;
                break;
            }
            case LocalVariable: {
                message = "LocalVariable_Long_CompareLocalVariable";
                other = this._otherLocalVariable;
                break;
            }
            case RegEx: {
                message = "LocalVariable_Long_CompareRegEx";
                other = this._regEx;
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._variableOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case GreaterThanOrEqual: 
            case GreaterThan: 
            case NotEqual: {
                return Bundle.getMessage(locale, message, variableName, this._variableOperation._text, other);
            }
            case IsNull: 
            case IsNotNull: {
                return Bundle.getMessage(locale, "LocalVariable_Long_CompareNull", variableName, this._variableOperation._text);
            }
            case MatchRegex: 
            case NotMatchRegex: {
                return Bundle.getMessage(locale, "LocalVariable_Long_CompareRegEx", variableName, this._variableOperation._text, other);
            }
        }
        throw new IllegalArgumentException("_variableOperation has unknown value: " + this._variableOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._memoryHandle != null) {
            if (this._listenToMemory) {
                this._memoryHandle.getBean().addPropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            if (this._listenToMemory && this._memoryHandle != null) {
                this._memoryHandle.getBean().removePropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionLocalVariable: bean = {}, report = {}", (Object)cdl, report);
        if (this.getMemory() != null && bean.equals(this.getMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
    }

    public static enum CompareTo {
        Value(Bundle.getMessage("LocalVariable_CompareTo_Value")),
        Memory(Bundle.getMessage("LocalVariable_CompareTo_Memory")),
        LocalVariable(Bundle.getMessage("LocalVariable_CompareTo_LocalVariable")),
        RegEx(Bundle.getMessage("LocalVariable_CompareTo_RegularExpression"));

        private final String _text;

        private CompareTo(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum VariableOperation {
        LessThan(Bundle.getMessage("LocalVariableOperation_LessThan"), true),
        LessThanOrEqual(Bundle.getMessage("LocalVariableOperation_LessThanOrEqual"), true),
        Equal(Bundle.getMessage("LocalVariableOperation_Equal"), true),
        GreaterThanOrEqual(Bundle.getMessage("LocalVariableOperation_GreaterThanOrEqual"), true),
        GreaterThan(Bundle.getMessage("LocalVariableOperation_GreaterThan"), true),
        NotEqual(Bundle.getMessage("LocalVariableOperation_NotEqual"), true),
        IsNull(Bundle.getMessage("LocalVariableOperation_IsNull"), false),
        IsNotNull(Bundle.getMessage("LocalVariableOperation_IsNotNull"), false),
        MatchRegex(Bundle.getMessage("LocalVariableOperation_MatchRegEx"), true),
        NotMatchRegex(Bundle.getMessage("LocalVariableOperation_NotMatchRegEx"), true);

        private final String _text;
        private final boolean _extraValue;

        private VariableOperation(String text, boolean extraValue) {
            this._text = text;
            this._extraValue = extraValue;
        }

        public String toString() {
            return this._text;
        }

        public boolean hasExtraValue() {
            return this._extraValue;
        }
    }
}

