/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEntryExit
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<DestinationPoints> _entryDestinationPoints;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private EntryExitState _entryExitState = EntryExitState.Active;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ExpressionEntryExit.class);

    public ExpressionEntryExit(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionEntryExit copy = new ExpressionEntryExit(sysName, userName);
        copy.setComment(this.getComment());
        if (this._entryDestinationPoints != null) {
            copy.setDestinationPoints(this._entryDestinationPoints);
        }
        copy.setBeanState(this._entryExitState);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setStateAddressing(this._stateAddressing);
        copy.setStateFormula(this._stateFormula);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateReference(this._stateReference);
        return manager.registerExpression(copy);
    }

    public void setDestinationPoints(@Nonnull String entryExitName) {
        this.assertListenersAreNotRegistered(log, "setEntryExit");
        DestinationPoints destinationPoints = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(entryExitName);
        if (destinationPoints != null) {
            this.setDestinationPoints(destinationPoints);
        } else {
            this.removeDestinationPoints();
            log.warn("destinationPoints \"{}\" is not found", (Object)entryExitName);
        }
    }

    public void setDestinationPoints(@Nonnull NamedBeanHandle<DestinationPoints> handle) {
        this.assertListenersAreNotRegistered(log, "setEntryExit");
        this._entryDestinationPoints = handle;
        InstanceManager.getDefault(EntryExitPairs.class).addVetoableChangeListener(this);
    }

    public void setDestinationPoints(@Nonnull DestinationPoints destinationPoints) {
        this.assertListenersAreNotRegistered(log, "setEntryExit");
        this.setDestinationPoints(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(destinationPoints.getDisplayName(), destinationPoints));
    }

    public void removeDestinationPoints() {
        this.assertListenersAreNotRegistered(log, "setEntryExit");
        if (this._entryDestinationPoints != null) {
            InstanceManager.getDefault(EntryExitPairs.class).removeVetoableChangeListener(this);
            this._entryDestinationPoints = null;
        }
    }

    public NamedBeanHandle<DestinationPoints> getEntryExit() {
        return this._entryDestinationPoints;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setBeanState(EntryExitState state) {
        this._entryExitState = state;
    }

    public EntryExitState getBeanState() {
        return this._entryExitState;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof DestinationPoints && evt.getOldValue().equals(this.getEntryExit().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("EntryExit_EntryExitInUseEntryExitExpressionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof DestinationPoints && evt.getOldValue().equals(this.getEntryExit().getBean())) {
            this.removeDestinationPoints();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    @Override
    public boolean evaluate() throws JmriException {
        DestinationPoints destinationPoints;
        switch (this._addressing) {
            case Direct: {
                destinationPoints = this._entryDestinationPoints != null ? this._entryDestinationPoints.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                destinationPoints = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                destinationPoints = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                destinationPoints = this._expressionNode != null ? InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (destinationPoints == null) {
            return false;
        }
        EntryExitState checkEntryExitState = this._stateAddressing == NamedBeanAddressing.Direct ? this._entryExitState : EntryExitState.valueOf(this.getNewState());
        EntryExitState currentEntryExitState = EntryExitState.get(destinationPoints.getState());
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return currentEntryExitState == checkEntryExitState;
        }
        return currentEntryExitState != checkEntryExitState;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "EntryExit_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String entryExitName = this._entryDestinationPoints != null ? this._entryDestinationPoints.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", entryExitName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._stateAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._entryExitState._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "EntryExit_Long", namedBean, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._entryDestinationPoints != null) {
            this._entryDestinationPoints.getBean().addPropertyChangeListener("active", this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._entryDestinationPoints.getBean().removePropertyChangeListener("active", this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionEntryExit: bean = {}, report = {}", (Object)cdl, report);
        if (this.getEntryExit() != null && bean.equals(this.getEntryExit().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
    }

    public static enum EntryExitState {
        Inactive(4, Bundle.getMessage("EntryExitStateInactive")),
        Active(2, Bundle.getMessage("EntryExitStateActive")),
        Other(-1, Bundle.getMessage("EntryExitOtherStatus"));

        private final int _id;
        private final String _text;

        private EntryExitState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static EntryExitState get(int id) {
            switch (id) {
                case 4: {
                    return Inactive;
                }
                case 2: {
                    return Active;
                }
            }
            return Other;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

