/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.DispatcherActiveTrainManager;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionDispatcher
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private String _trainInfoFileName = "";
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private DispatcherState _dispatcherState = DispatcherState.Mode;
    private final DispatcherActiveTrainManager _atManager = InstanceManager.getDefault(DispatcherActiveTrainManager.class);
    private boolean _activeTrainListeners = false;
    private ActiveTrain _activeTrain = null;
    private static final Logger log = LoggerFactory.getLogger(ExpressionDispatcher.class);

    public ExpressionDispatcher(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionDispatcher copy = new ExpressionDispatcher(sysName, userName);
        copy.setComment(this.getComment());
        copy.setTrainInfoFileName(this._trainInfoFileName);
        copy.setBeanState(this.getBeanState());
        copy.setBeanState(this._dispatcherState);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setStateAddressing(this._stateAddressing);
        copy.setStateFormula(this._stateFormula);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateReference(this._stateReference);
        return manager.registerExpression(copy);
    }

    public void setTrainInfoFileName(@Nonnull String fileName) {
        this._trainInfoFileName = fileName;
    }

    public String getTrainInfoFileName() {
        return this._trainInfoFileName;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    public void setBeanState(DispatcherState state) {
        this._dispatcherState = state;
    }

    public DispatcherState getBeanState() {
        return this._dispatcherState;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getSelectedFileName() throws JmriException {
        switch (this._addressing) {
            case Direct: {
                return this.getTrainInfoFileName();
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false);
            }
            case Formula: {
                return this._expressionNode != null ? TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : "";
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    @Override
    public boolean evaluate() throws JmriException {
        String trainInfoFileName = this.getSelectedFileName();
        if (trainInfoFileName.isEmpty()) {
            return false;
        }
        DispatcherState checkDispatcherState = this._stateAddressing == NamedBeanAddressing.Direct ? this._dispatcherState : DispatcherState.valueOf(this.getNewState());
        boolean result = false;
        switch (checkDispatcherState) {
            case Automatic: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getMode() == 2;
                break;
            }
            case Dispatched: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getMode() == 8;
                break;
            }
            case Manual: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getMode() == 4;
                break;
            }
            case Running: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 1;
                break;
            }
            case Paused: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 2;
                break;
            }
            case Waiting: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 4;
                break;
            }
            case Working: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 8;
                break;
            }
            case Ready: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 16;
                break;
            }
            case Stopped: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 32;
                break;
            }
            case Done: {
                if (this._activeTrain == null) break;
                result = this._activeTrain.getStatus() == 64;
                break;
            }
            default: {
                throw new UnsupportedOperationException("checkDispatcherState has unknown value: " + checkDispatcherState.name());
            }
        }
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return result;
        }
        return !result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Dispatcher_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String fileName;
        switch (this._addressing) {
            case Direct: {
                fileName = Bundle.getMessage(locale, "AddressByDirect", this._trainInfoFileName);
                break;
            }
            case Reference: {
                fileName = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                fileName = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                fileName = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._stateAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._dispatcherState._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "Dispatcher_Long", fileName, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._atManager.addPropertyChangeListener(this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._atManager.removePropertyChangeListener(this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "ActiveTrain": {
                this.manageActiveTrain(evt);
                break;
            }
            case "status": 
            case "mode": {
                this.getConditionalNG().execute();
                break;
            }
            default: {
                log.debug("Other property changes are ignored: name = " + evt.getPropertyName());
            }
        }
    }

    private void manageActiveTrain(PropertyChangeEvent event) {
        String selectedFileName;
        try {
            selectedFileName = this.getSelectedFileName();
        }
        catch (JmriException jmriException) {
            log.warn("Unexpected exception, using Direct file name");
            selectedFileName = this._trainInfoFileName;
        }
        String eventFileName = (String)event.getOldValue();
        if (eventFileName.isEmpty()) {
            eventFileName = (String)event.getNewValue();
        }
        if (!selectedFileName.equals(eventFileName)) {
            return;
        }
        ActiveTrain checkTrain = this._atManager.getActiveTrain(selectedFileName);
        if (checkTrain == null) {
            if (this._activeTrain != null) {
                if (this._activeTrainListeners) {
                    this._activeTrain.removePropertyChangeListener(this);
                    this._activeTrainListeners = false;
                }
                this._activeTrain = null;
            }
            return;
        }
        if (checkTrain == this._activeTrain) {
            return;
        }
        if (this._activeTrain == null) {
            this._activeTrain = checkTrain;
            this._activeTrainListeners = false;
        }
        if (!this._activeTrainListeners) {
            this._activeTrain.addPropertyChangeListener(this);
            this._activeTrainListeners = true;
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionDispatcher: bean = {}, report = {}", (Object)cdl, report);
    }

    public static enum DispatcherState {
        Mode(Bundle.getMessage("DispatcherSeparatorMode"), "Separator"),
        Automatic(Bundle.getMessage("DispatcherMode_Automatic"), "Mode"),
        Dispatched(Bundle.getMessage("DispatcherMode_Dispatched"), "Mode"),
        Manual(Bundle.getMessage("DispatcherMode_Manual"), "Mode"),
        Status(Bundle.getMessage("DispatcherSeparatorStatus"), "Separator"),
        Running(Bundle.getMessage("DispatcherStatus_Running"), "Status"),
        Paused(Bundle.getMessage("DispatcherStatus_Paused"), "Status"),
        Waiting(Bundle.getMessage("DispatcherStatus_Waiting"), "Status"),
        Working(Bundle.getMessage("DispatcherStatus_Working"), "Status"),
        Ready(Bundle.getMessage("DispatcherStatus_Ready"), "Status"),
        Stopped(Bundle.getMessage("DispatcherStatus_Stopped"), "Status"),
        Done(Bundle.getMessage("DispatcherStatus_Done"), "Status");

        private final String _text;
        private final String _type;

        private DispatcherState(String text, String type) {
            this._text = text;
            this._type = type;
        }

        public String getType() {
            return this._type;
        }

        public String toString() {
            return this._text;
        }
    }
}

