/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalCallModule
extends AbstractDigitalExpression
implements VetoableChangeListener {
    private NamedBeanHandle<Module> _moduleHandle;
    private final List<Module.ParameterData> _parameterData = new ArrayList<Module.ParameterData>();
    private static final Logger log = LoggerFactory.getLogger(DigitalCallModule.class);

    public DigitalCallModule(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = systemNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        DigitalCallModule copy = new DigitalCallModule(sysName, userName);
        if (this._moduleHandle != null) {
            copy.setModule(this._moduleHandle);
        }
        for (Module.ParameterData data : this._parameterData) {
            copy.addParameter(data.getName(), data.getInitialValueType(), data.getInitialValueData(), data.getReturnValueType(), data.getReturnValueData());
        }
        return manager.registerExpression(copy);
    }

    public void setModule(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setModule");
        Module memory = InstanceManager.getDefault(ModuleManager.class).getModule(memoryName);
        if (memory != null) {
            this.setModule(memory);
        } else {
            this.removeModule();
            log.error("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setModule(@Nonnull NamedBeanHandle<Module> handle) {
        this.assertListenersAreNotRegistered(log, "setModule");
        this._moduleHandle = handle;
        InstanceManager.getDefault(ModuleManager.class).addVetoableChangeListener(this);
    }

    public void setModule(@Nonnull Module module) {
        this.assertListenersAreNotRegistered(log, "setModule");
        this.setModule(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(module.getDisplayName(), module));
    }

    public void removeModule() {
        this.assertListenersAreNotRegistered(log, "setModule");
        if (this._moduleHandle != null) {
            InstanceManager.getDefault(ModuleManager.class).removeVetoableChangeListener(this);
            this._moduleHandle = null;
        }
    }

    public NamedBeanHandle<Module> getModule() {
        return this._moduleHandle;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Module && evt.getOldValue().equals(this.getModule().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("CallModule_ModuleInUseVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Module && evt.getOldValue().equals(this.getModule().getBean())) {
            this.removeModule();
        }
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    public void returnSymbols(DefaultSymbolTable symbolTable, Collection<Module.ParameterData> symbolDefinitions) throws JmriException {
        block5: for (Module.ParameterData parameter : symbolDefinitions) {
            Object returnValue = symbolTable.getValue(parameter.getName());
            switch (parameter.getReturnValueType()) {
                case None: {
                    break;
                }
                case LocalVariable: {
                    symbolTable.getPrevSymbolTable().setValue(parameter.getReturnValueData(), returnValue);
                    break;
                }
                case Memory: {
                    Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(parameter.getReturnValueData());
                    if (m == null) continue block5;
                    m.setValue(returnValue);
                    break;
                }
                default: {
                    log.error("definition.returnValueType has invalid value: {}", (Object)parameter.getReturnValueType().name());
                    throw new IllegalArgumentException("definition._returnValueType has invalid value: " + parameter.getReturnValueType().name());
                }
            }
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        if (this._moduleHandle == null) {
            return false;
        }
        Module module = this._moduleHandle.getBean();
        ConditionalNG oldConditionalNG = this.getConditionalNG();
        module.setCurrentConditionalNG(this.getConditionalNG());
        FemaleSocket femaleSocket = module.getRootSocket();
        if (!(femaleSocket instanceof FemaleDigitalExpressionSocket)) {
            log.error("module.rootSocket is not a FemaleDigitalExpressionSocket");
            return false;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG);
        newSymbolTable.createSymbols(conditionalNG.getSymbolTable(), this._parameterData);
        newSymbolTable.createSymbols(module.getLocalVariables());
        conditionalNG.setSymbolTable(newSymbolTable);
        boolean result = ((FemaleDigitalExpressionSocket)femaleSocket).evaluate();
        this.returnSymbols(newSymbolTable, this._parameterData);
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.setSymbolTable(newSymbolTable.getPrevSymbolTable());
        module.setCurrentConditionalNG(oldConditionalNG);
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "DigitalCallModule_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String moduleName = this._moduleHandle != null ? this._moduleHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
        return Bundle.getMessage(locale, "DigitalCallModule_Long", moduleName);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
        this.removeModule();
    }

    public void addParameter(String name, SymbolTable.InitialValueType initialValueType, String initialValueData, Module.ReturnValueType returnValueType, String returnValueData) {
        this._parameterData.add(new Module.ParameterData(name, initialValueType, initialValueData, returnValueType, returnValueData));
    }

    public List<Module.ParameterData> getParameterData() {
        return this._parameterData;
    }
}

