/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class And
extends AbstractDigitalExpression
implements FemaleSocketListener {
    private final List<ExpressionEntry> _expressionEntries = new ArrayList<ExpressionEntry>();
    private boolean disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(And.class);

    public And(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._expressionEntries.add(new ExpressionEntry(InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName())));
    }

    public And(String sys, String user, List<Map.Entry<String, String>> expressionSystemNames) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this.setExpressionSystemNames(expressionSystemNames);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        And copy = new And(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNumSockets(this.getChildCount());
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setExpressionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._expressionEntries.isEmpty()) {
            throw new RuntimeException("expression system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._expressionEntries.add(new ExpressionEntry(socket, entry.getValue()));
        }
    }

    public String getExpressionSystemName(int index) {
        return this._expressionEntries.get(index)._socketSystemName;
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result = true;
        for (ExpressionEntry e : this._expressionEntries) {
            if (!e._socket.isConnected() || e._socket.evaluate()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        return this._expressionEntries.get(index)._socket;
    }

    @Override
    public int getChildCount() {
        return this._expressionEntries.size();
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "And_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "And_Long");
    }

    private void setNumSockets(int num) {
        ArrayList<FemaleDigitalExpressionSocket> addList = new ArrayList<FemaleDigitalExpressionSocket>();
        while (this._expressionEntries.size() < num) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            addList.add(socket);
        }
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void checkFreeSocket() {
        boolean hasFreeSocket = false;
        for (ExpressionEntry entry : this._expressionEntries) {
            hasFreeSocket |= !entry._socket.isConnected();
        }
        if (!hasFreeSocket) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            ArrayList<FemaleDigitalExpressionSocket> list = new ArrayList<FemaleDigitalExpressionSocket>();
            list.add(socket);
            this.firePropertyChange("ChildCount", null, list);
        }
    }

    @Override
    public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                return !this.getChild(index).isConnected();
            }
            case InsertBefore: {
                return true;
            }
            case InsertAfter: {
                return true;
            }
            case MoveUp: {
                return index > 0;
            }
            case MoveDown: {
                return index + 1 < this.getChildCount();
            }
        }
        throw new UnsupportedOperationException("Oper is unknown" + oper.name());
    }

    private void insertNewSocket(int index) {
        FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
        this._expressionEntries.add(index, new ExpressionEntry(socket));
        ArrayList<FemaleDigitalExpressionSocket> addList = new ArrayList<FemaleDigitalExpressionSocket>();
        addList.add(socket);
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void removeSocket(int index) {
        ArrayList<FemaleDigitalExpressionSocket> removeList = new ArrayList<FemaleDigitalExpressionSocket>();
        removeList.add(this._expressionEntries.remove(index)._socket);
        this.firePropertyChange("ChildCount", removeList, null);
    }

    private void moveSocketDown(int index) {
        ExpressionEntry temp = this._expressionEntries.get(index);
        this._expressionEntries.set(index, this._expressionEntries.get(index + 1));
        this._expressionEntries.set(index + 1, temp);
        ArrayList<FemaleDigitalExpressionSocket> list = new ArrayList<FemaleDigitalExpressionSocket>();
        list.add(this._expressionEntries.get(index)._socket);
        list.add(this._expressionEntries.get(index)._socket);
        this.firePropertyChange("ChildReorder", null, list);
    }

    @Override
    public void doSocketOperation(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                if (this.getChild(index).isConnected()) {
                    throw new UnsupportedOperationException("Socket is connected");
                }
                this.removeSocket(index);
                break;
            }
            case InsertBefore: {
                this.insertNewSocket(index);
                break;
            }
            case InsertAfter: {
                this.insertNewSocket(index + 1);
                break;
            }
            case MoveUp: {
                if (index == 0) {
                    throw new UnsupportedOperationException("cannot move up first child");
                }
                this.moveSocketDown(index - 1);
                break;
            }
            case MoveDown: {
                if (index + 1 == this.getChildCount()) {
                    throw new UnsupportedOperationException("cannot move down last child");
                }
                this.moveSocketDown(index);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oper is unknown" + oper.name());
            }
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this.disableCheckForUnconnectedSocket) {
            return;
        }
        for (ExpressionEntry entry : this._expressionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
        this.checkFreeSocket();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        for (ExpressionEntry entry : this._expressionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = null;
            break;
        }
    }

    @Override
    public void setup() {
        this.disableCheckForUnconnectedSocket = true;
        for (ExpressionEntry ee : this._expressionEntries) {
            try {
                if (!ee._socket.isConnected() || !ee._socket.getConnectedSocket().getSystemName().equals(ee._socketSystemName)) {
                    String socketSystemName = ee._socketSystemName;
                    ee._socket.disconnect();
                    if (socketSystemName == null) continue;
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        ee._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load digital expression " + socketSystemName);
                    continue;
                }
                ee._socket.getConnectedSocket().setup();
            }
            catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
                throw new RuntimeException("socket is already connected");
            }
        }
        this.checkFreeSocket();
        this.disableCheckForUnconnectedSocket = false;
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    private static class ExpressionEntry {
        private String _socketSystemName;
        private final FemaleDigitalExpressionSocket _socket;

        private ExpressionEntry(FemaleDigitalExpressionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ExpressionEntry(FemaleDigitalExpressionSocket socket) {
            this._socket = socket;
        }
    }
}

