/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractAnalogExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogExpressionConstant
extends AbstractAnalogExpression {
    private double _value;
    private static final Logger log = LoggerFactory.getLogger(AnalogExpressionConstant.class);

    public AnalogExpressionConstant(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        AnalogExpressionManager manager = InstanceManager.getDefault(AnalogExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        AnalogExpressionConstant copy = new AnalogExpressionConstant(sysName, userName);
        copy.setComment(this.getComment());
        copy.setValue(this._value);
        return manager.registerExpression(copy);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public void setValue(double value) {
        this.assertListenersAreNotRegistered(log, "setValue");
        this._value = value;
    }

    public double getValue() {
        return this._value;
    }

    @Override
    public double evaluate() {
        return this._value;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogExpressionConstant_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        return Bundle.getMessage(locale, "AnalogExpressionConstant_Long", numberFormat.format(this._value));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }
}

