/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.AnalogIO;
import jmri.AnalogIOManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractAnalogExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogExpressionAnalogIO
extends AbstractAnalogExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanHandle<AnalogIO> _analogIOHandle;
    private static final Logger log = LoggerFactory.getLogger(AnalogExpressionAnalogIO.class);

    public AnalogExpressionAnalogIO(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        AnalogExpressionManager manager = InstanceManager.getDefault(AnalogExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        AnalogExpressionAnalogIO copy = new AnalogExpressionAnalogIO(sysName, userName);
        copy.setComment(this.getComment());
        if (this._analogIOHandle != null) {
            copy.setAnalogIO(this._analogIOHandle);
        }
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof AnalogIO && evt.getOldValue().equals(this.getAnalogIO().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("AnalogIO_AnalogIOInUseAnalogIOExpressionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof AnalogIO && evt.getOldValue().equals(this.getAnalogIO().getBean())) {
            this.removeAnalogIO();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public void setAnalogIO(@Nonnull String analogIOName) {
        this.assertListenersAreNotRegistered(log, "setAnalogIO");
        AnalogIO analogIO = (AnalogIO)InstanceManager.getDefault(AnalogIOManager.class).getNamedBean(analogIOName);
        if (analogIO != null) {
            this.setAnalogIO(analogIO);
        } else {
            this.removeAnalogIO();
            log.error("analogIO \"{}\" is not found", (Object)analogIOName);
        }
    }

    public void setAnalogIO(@Nonnull NamedBeanHandle<AnalogIO> handle) {
        this.assertListenersAreNotRegistered(log, "setAnalogIO");
        this._analogIOHandle = handle;
        InstanceManager.getDefault(AnalogIOManager.class).addVetoableChangeListener(this);
    }

    public void setAnalogIO(@Nonnull AnalogIO analogIO) {
        this.assertListenersAreNotRegistered(log, "setAnalogIO");
        this.setAnalogIO(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(analogIO.getDisplayName(), analogIO));
    }

    public void removeAnalogIO() {
        this.assertListenersAreNotRegistered(log, "setAnalogIO");
        if (this._analogIOHandle != null) {
            InstanceManager.getDefault(AnalogIOManager.class).removeVetoableChangeListener(this);
            this._analogIOHandle = null;
        }
    }

    public NamedBeanHandle<AnalogIO> getAnalogIO() {
        return this._analogIOHandle;
    }

    @Override
    public double evaluate() {
        if (this._analogIOHandle != null) {
            return TypeConversionUtil.convertToDouble(this._analogIOHandle.getBean().getKnownAnalogValue(), false);
        }
        return 0.0;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogExpressionAnalogIO_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._analogIOHandle != null) {
            return Bundle.getMessage(locale, "AnalogExpressionAnalogIO_Long", this._analogIOHandle.getBean().getDisplayName());
        }
        return Bundle.getMessage(locale, "AnalogExpressionAnalogIO_Long", "none");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._analogIOHandle != null) {
            this._analogIOHandle.getBean().addPropertyChangeListener("value", this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._analogIOHandle.getBean().removePropertyChangeListener("value", this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getTriggerOnChange()) {
            this.getConditionalNG().execute();
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: AnalogExpressionAnalogIO: bean = {}, report = {}", (Object)cdl, report);
        if (this.getAnalogIO() != null && bean.equals(this.getAnalogIO().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
        }
    }
}

