/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.Timeout;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.JComboBoxUtil;

public class TimeoutSwing
extends AbstractDigitalActionSwing {
    private final JLabel _unitLabel = new JLabel(Bundle.getMessage("ExecuteDelayedSwing_Unit"));
    private JComboBox<TimerUnit> _unitComboBox;
    private JTabbedPane _tabbedPaneDelay;
    private JFormattedTextField _timerDelay;
    private JPanel _panelDelayDirect;
    private JPanel _panelDelayReference;
    private JPanel _panelDelayLocalVariable;
    private JPanel _panelDelayFormula;
    private JTextField _delayReferenceTextField;
    private JTextField _delayLocalVariableTextField;
    private JTextField _delayFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof Timeout)) {
            throw new IllegalArgumentException("object must be an Timeout but is a: " + object.getClass().getName());
        }
        Timeout action = (Timeout)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this._tabbedPaneDelay = new JTabbedPane();
        this._panelDelayDirect = new JPanel();
        this._panelDelayReference = new JPanel();
        this._panelDelayLocalVariable = new JPanel();
        this._panelDelayFormula = new JPanel();
        this._tabbedPaneDelay.addTab(NamedBeanAddressing.Direct.toString(), this._panelDelayDirect);
        this._tabbedPaneDelay.addTab(NamedBeanAddressing.Reference.toString(), this._panelDelayReference);
        this._tabbedPaneDelay.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelDelayLocalVariable);
        this._tabbedPaneDelay.addTab(NamedBeanAddressing.Formula.toString(), this._panelDelayFormula);
        this._timerDelay = new JFormattedTextField((Object)"0");
        this._timerDelay.setColumns(7);
        this._panelDelayDirect.add(this._timerDelay);
        this._delayReferenceTextField = new JTextField();
        this._delayReferenceTextField.setColumns(30);
        this._panelDelayReference.add(this._delayReferenceTextField);
        this._delayLocalVariableTextField = new JTextField();
        this._delayLocalVariableTextField.setColumns(30);
        this._panelDelayLocalVariable.add(this._delayLocalVariableTextField);
        this._delayFormulaTextField = new JTextField();
        this._delayFormulaTextField.setColumns(30);
        this._panelDelayFormula.add(this._delayFormulaTextField);
        if (action != null) {
            switch (action.getDelayAddressing()) {
                case Direct: {
                    this._tabbedPaneDelay.setSelectedComponent(this._panelDelayDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneDelay.setSelectedComponent(this._panelDelayReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneDelay.setSelectedComponent(this._panelDelayLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneDelay.setSelectedComponent(this._panelDelayFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getDelayAddressing().name());
                }
            }
            this._timerDelay.setText(Integer.toString(action.getDelay()));
            this._delayReferenceTextField.setText(action.getDelayReference());
            this._delayLocalVariableTextField.setText(action.getDelayLocalVariable());
            this._delayFormulaTextField.setText(action.getDelayFormula());
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneDelay};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExecuteDelayed_Components"), components);
        JPanel delayPanel = new JPanel();
        for (JComponent c : componentList) {
            delayPanel.add(c);
        }
        this.panel.add(delayPanel);
        JPanel unitPanel = new JPanel();
        unitPanel.add(this._unitLabel);
        this._unitComboBox = new JComboBox();
        TimerUnit[] timerUnitArray = TimerUnit.values();
        int n = timerUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimerUnit u = timerUnitArray[n2];
            this._unitComboBox.addItem(u);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._unitComboBox);
        if (action != null) {
            this._unitComboBox.setSelectedItem((Object)action.getUnit());
        }
        unitPanel.add(this._unitComboBox);
        this.panel.add(unitPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block9: {
            Timeout action = new Timeout("IQDA1", null);
            try {
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayReference) {
                    action.setDelayReference(this._delayReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setDelayFormula(this._delayFormulaTextField.getText());
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayDirect) {
                    action.setDelayAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayReference) {
                    action.setDelayAddressing(NamedBeanAddressing.Reference);
                    break block9;
                }
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayLocalVariable) {
                    action.setDelayAddressing(NamedBeanAddressing.LocalVariable);
                    break block9;
                }
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayFormula) {
                    action.setDelayAddressing(NamedBeanAddressing.Formula);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        Timeout action = new Timeout(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block7: {
            if (!(object instanceof Timeout)) {
                throw new IllegalArgumentException("object must be an Timeout but is a: " + object.getClass().getName());
            }
            Timeout action = (Timeout)object;
            action.setUnit(this._unitComboBox.getItemAt(this._unitComboBox.getSelectedIndex()));
            try {
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayDirect) {
                    action.setDelayAddressing(NamedBeanAddressing.Direct);
                    action.setDelay(Integer.parseInt(this._timerDelay.getText()));
                    break block7;
                }
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayReference) {
                    action.setDelayAddressing(NamedBeanAddressing.Reference);
                    action.setDelayReference(this._delayReferenceTextField.getText());
                    break block7;
                }
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayLocalVariable) {
                    action.setDelayAddressing(NamedBeanAddressing.LocalVariable);
                    action.setDelayLocalVariable(this._delayLocalVariableTextField.getText());
                    break block7;
                }
                if (this._tabbedPaneDelay.getSelectedComponent() == this._panelDelayFormula) {
                    action.setDelayAddressing(NamedBeanAddressing.Formula);
                    action.setDelayFormula(this._delayFormulaTextField.getText());
                    break block7;
                }
                throw new IllegalArgumentException("_tabbedPaneDelay has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Timeout_Short");
    }

    @Override
    public void dispose() {
    }
}

