/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.Sequence;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;

public class SequenceSwing
extends AbstractDigitalActionSwing {
    private JCheckBox _startImmediately;
    private JCheckBox _runContinuously;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof Sequence)) {
            throw new IllegalArgumentException("object must be an Sequence but is a: " + object.getClass().getName());
        }
        Sequence action = (Sequence)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this._startImmediately = new JCheckBox(Bundle.getMessage("SequenceSwing_StartImmediately"));
        this._runContinuously = new JCheckBox(Bundle.getMessage("SequenceSwing_RunContinuously"));
        if (action != null) {
            this._startImmediately.setSelected(action.getStartImmediately());
            this._runContinuously.setSelected(action.getRunContinuously());
        }
        this.panel.add(this._startImmediately);
        this.panel.add(this._runContinuously);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        Sequence action = new Sequence(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof Sequence)) {
            throw new IllegalArgumentException("object must be an Sequence but is a: " + object.getClass().getName());
        }
        Sequence action = (Sequence)object;
        action.setStartImmediately(this._startImmediately.isSelected());
        action.setRunContinuously(this._runContinuously.isSelected());
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Sequence_Short");
    }

    @Override
    public void dispose() {
    }
}

