/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.DigitalFormula;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalFormulaSwing
extends AbstractDigitalActionSwing {
    private JTextField _formula;
    private static final Logger log = LoggerFactory.getLogger(DigitalFormulaSwing.class);

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        DigitalFormula action = (DigitalFormula)object;
        this.panel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("DigitalFormula_Formula"));
        this._formula = new JTextField();
        this._formula.setColumns(40);
        if (action != null) {
            this._formula.setText(action.getFormula());
        }
        this.panel.add(label);
        this.panel.add(this._formula);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        if (this._formula.getText().isEmpty()) {
            return true;
        }
        try {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            parser.parseExpression(this._formula.getText());
        }
        catch (ParserException ex) {
            errorMessages.add(Bundle.getMessage("DigitalFormula_InvalidFormula", this._formula.getText()));
            log.error("Invalid formula '" + this._formula.getText() + "'. Error: " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        DigitalFormula action = new DigitalFormula(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof DigitalFormula)) {
            throw new IllegalArgumentException("object must be an DigitalFormula but is a: " + object.getClass().getName());
        }
        DigitalFormula action = (DigitalFormula)object;
        try {
            action.setFormula(this._formula.getText());
        }
        catch (ParserException ex) {
            log.error("Error when parsing formula", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("DigitalFormula_Short");
    }

    @Override
    public void dispose() {
    }
}

