/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionTimer;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.util.swing.JComboBoxUtil;

public class ActionTimerSwing
extends AbstractDigitalActionSwing {
    public static final int MAX_NUM_TIMERS = 10;
    private JCheckBox _startImmediately;
    private JCheckBox _runContinuously;
    private JComboBox<TimerUnit> _unitComboBox;
    private JTextField _numTimers;
    private JButton _addTimer;
    private JButton _removeTimer;
    private JTextField[] _timerSocketNames;
    private JTextField[] _timerDelays;
    private int numActions = 1;

    private String getNewSocketName(ActionTimer action) {
        int size = 12;
        String[] names = new String[size];
        names[0] = action.getStartExpressionSocket().getName();
        names[1] = action.getStopExpressionSocket().getName();
        int i = 0;
        while (i < 10) {
            names[2 + i] = this._timerSocketNames[i].getText();
            ++i;
        }
        return action.getNewSocketName(names);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof ActionTimer)) {
            throw new IllegalArgumentException("object must be an ActionTimer but is a: " + object.getClass().getName());
        }
        ActionTimer action = object != null ? (ActionTimer)object : new ActionTimer("IQDA1", null);
        this.numActions = action.getNumActions();
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this._startImmediately = new JCheckBox(Bundle.getMessage("ActionTimerSwing_StartImmediately"));
        this._runContinuously = new JCheckBox(Bundle.getMessage("ActionTimerSwing_RunContinuously"));
        this._unitComboBox = new JComboBox();
        TimerUnit[] timerUnitArray = TimerUnit.values();
        int n = timerUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimerUnit u = timerUnitArray[n2];
            this._unitComboBox.addItem(u);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._unitComboBox);
        this._unitComboBox.setSelectedItem((Object)action.getUnit());
        this.panel.add(this._startImmediately);
        this.panel.add(this._runContinuously);
        JPanel unitPanel = new JPanel();
        unitPanel.add(this._unitComboBox);
        this.panel.add(unitPanel);
        JPanel numActionsPanel = new JPanel();
        this._numTimers = new JTextField(Integer.toString(this.numActions));
        this._numTimers.setColumns(2);
        this._numTimers.setEnabled(false);
        this._addTimer = new JButton(Bundle.getMessage("ActionTimerSwing_AddTimer"));
        this._addTimer.addActionListener(e -> {
            ++this.numActions;
            this._numTimers.setText(Integer.toString(this.numActions));
            if (this._timerSocketNames[this.numActions - 1].getText().trim().isEmpty()) {
                this._timerSocketNames[this.numActions - 1].setText(this.getNewSocketName(action));
            }
            this._timerSocketNames[this.numActions - 1].setEnabled(true);
            this._timerDelays[this.numActions - 1].setEnabled(true);
            if (this.numActions >= 10) {
                this._addTimer.setEnabled(false);
            }
            this._removeTimer.setEnabled(true);
        });
        if (this.numActions >= 10) {
            this._addTimer.setEnabled(false);
        }
        this._removeTimer = new JButton(Bundle.getMessage("ActionTimerSwing_RemoveTimer"));
        this._removeTimer.addActionListener(e -> {
            this._timerSocketNames[this.numActions - 1].setEnabled(false);
            this._timerDelays[this.numActions - 1].setEnabled(false);
            --this.numActions;
            this._numTimers.setText(Integer.toString(this.numActions));
            this._addTimer.setEnabled(true);
            if (this.numActions <= 1 || action.getNumActions() >= this.numActions && action.getActionSocket(this.numActions - 1).isConnected()) {
                this._removeTimer.setEnabled(false);
            }
        });
        if (this.numActions <= 1 || action.getActionSocket(this.numActions - 1).isConnected()) {
            this._removeTimer.setEnabled(false);
        }
        numActionsPanel.add(new JLabel(Bundle.getMessage("ActionTimerSwing_NumTimers")));
        numActionsPanel.add(this._numTimers);
        numActionsPanel.add(this._addTimer);
        numActionsPanel.add(this._removeTimer);
        this.panel.add(numActionsPanel);
        JPanel timerDelaysPanel = new JPanel();
        timerDelaysPanel.setLayout(new BoxLayout(timerDelaysPanel, 1));
        timerDelaysPanel.add(new JLabel(Bundle.getMessage("ActionTimerSwing_TimerDelays")));
        JPanel timerDelaysSubPanel = new JPanel();
        this._timerSocketNames = new JTextField[10];
        this._timerDelays = new JTextField[10];
        int i = 0;
        while (i < 10) {
            JPanel delayPanel = new JPanel();
            delayPanel.setLayout(new BoxLayout(delayPanel, 1));
            this._timerDelays[i] = new JTextField("0");
            this._timerDelays[i].setColumns(7);
            this._timerDelays[i].setEnabled(false);
            delayPanel.add(this._timerDelays[i]);
            this._timerSocketNames[i] = new JTextField();
            this._timerSocketNames[i].setEnabled(false);
            delayPanel.add(this._timerSocketNames[i]);
            timerDelaysSubPanel.add(delayPanel);
            if (i < action.getNumActions()) {
                String socketName = action.getActionSocket(i).getName();
                this._timerSocketNames[i].setText(socketName);
                this._timerSocketNames[i].setEnabled(true);
                this._timerDelays[i].setText(Integer.toString(action.getDelay(i)));
                this._timerDelays[i].setEnabled(true);
            }
            ++i;
        }
        timerDelaysPanel.add(timerDelaysSubPanel);
        this.panel.add(timerDelaysPanel);
        this._startImmediately.setSelected(action.getStartImmediately());
        this._runContinuously.setSelected(action.getRunContinuously());
        this._numTimers.setText(Integer.toString(action.getNumActions()));
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionTimer tempAction = new ActionTimer("IQDA1", null);
        boolean hasErrors = false;
        int i = 0;
        while (i < this.numActions) {
            if (!tempAction.getActionSocket(0).validateName(this._timerSocketNames[i].getText())) {
                errorMessages.add(Bundle.getMessage("InvalidSocketName", this._timerSocketNames[i].getText()));
                hasErrors = true;
            }
            ++i;
        }
        return !hasErrors;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionTimer action = new ActionTimer(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionTimer)) {
            throw new IllegalArgumentException("object must be an ActionTimer but is a: " + object.getClass().getName());
        }
        ActionTimer action = (ActionTimer)object;
        action.setStartImmediately(this._startImmediately.isSelected());
        action.setRunContinuously(this._runContinuously.isSelected());
        action.setUnit(this._unitComboBox.getItemAt(this._unitComboBox.getSelectedIndex()));
        action.setNumActions(this.numActions);
        int i = 0;
        while (i < this.numActions) {
            action.getActionSocket(i).setName(this._timerSocketNames[i].getText());
            action.setDelay(i, Integer.parseInt(this._timerDelays[i].getText()));
            ++i;
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionTimer_Short");
    }

    @Override
    public void dispose() {
    }
}

