/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionMemory;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.BeanSelectPanel;

public class ActionMemorySwing
extends AbstractDigitalActionSwing {
    private JTabbedPane _tabbedPaneMemory;
    private BeanSelectPanel<Memory> _memoryBeanPanel;
    private JPanel _panelMemoryDirect;
    private JPanel _panelMemoryReference;
    private JPanel _panelMemoryLocalVariable;
    private JPanel _panelMemoryFormula;
    private JTextField _memoryReferenceTextField;
    private JTextField _memoryLocalVariableTextField;
    private JTextField _memoryFormulaTextField;
    private JTabbedPane _tabbedPaneMemoryOperation;
    private BeanSelectPanel<Memory> _copyMemoryBeanPanel;
    private JPanel _setToNull;
    private JPanel _setToConstant;
    private JPanel _copyMemory;
    private JPanel _copyTableCell;
    private JPanel _copyVariable;
    private JPanel _calculateFormula;
    private JTextField _setToConstantTextField;
    private JTextField _copyTableCellTextField;
    private JTextField _copyLocalVariableTextField;
    private JTextField _calculateFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionMemory action = (ActionMemory)object;
        this.panel = new JPanel();
        this._tabbedPaneMemory = new JTabbedPane();
        this._panelMemoryDirect = new JPanel();
        this._panelMemoryReference = new JPanel();
        this._panelMemoryLocalVariable = new JPanel();
        this._panelMemoryFormula = new JPanel();
        this._tabbedPaneMemory.addTab(NamedBeanAddressing.Direct.toString(), this._panelMemoryDirect);
        this._tabbedPaneMemory.addTab(NamedBeanAddressing.Reference.toString(), this._panelMemoryReference);
        this._tabbedPaneMemory.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelMemoryLocalVariable);
        this._tabbedPaneMemory.addTab(NamedBeanAddressing.Formula.toString(), this._panelMemoryFormula);
        this._memoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._panelMemoryDirect.add(this._memoryBeanPanel);
        this._memoryReferenceTextField = new JTextField();
        this._memoryReferenceTextField.setColumns(30);
        this._panelMemoryReference.add(this._memoryReferenceTextField);
        this._memoryLocalVariableTextField = new JTextField();
        this._memoryLocalVariableTextField.setColumns(30);
        this._panelMemoryLocalVariable.add(this._memoryLocalVariableTextField);
        this._memoryFormulaTextField = new JTextField();
        this._memoryFormulaTextField.setColumns(30);
        this._panelMemoryFormula.add(this._memoryFormulaTextField);
        this._tabbedPaneMemoryOperation = new JTabbedPane();
        this._setToNull = new JPanel();
        this._setToConstant = new JPanel();
        this._copyMemory = new JPanel();
        this._copyTableCell = new JPanel();
        this._copyVariable = new JPanel();
        this._calculateFormula = new JPanel();
        this._tabbedPaneMemoryOperation.addTab(ActionMemory.MemoryOperation.SetToNull.toString(), this._setToNull);
        this._tabbedPaneMemoryOperation.addTab(ActionMemory.MemoryOperation.SetToString.toString(), this._setToConstant);
        this._tabbedPaneMemoryOperation.addTab(ActionMemory.MemoryOperation.CopyMemoryToMemory.toString(), this._copyMemory);
        this._tabbedPaneMemoryOperation.addTab(ActionMemory.MemoryOperation.CopyTableCellToMemory.toString(), this._copyTableCell);
        this._tabbedPaneMemoryOperation.addTab(ActionMemory.MemoryOperation.CopyVariableToMemory.toString(), this._copyVariable);
        this._tabbedPaneMemoryOperation.addTab(ActionMemory.MemoryOperation.CalculateFormula.toString(), this._calculateFormula);
        this._setToNull.add(new JLabel("Null"));
        this._setToConstantTextField = new JTextField(30);
        this._setToConstant.add(this._setToConstantTextField);
        this._copyMemoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._copyMemory.add(this._copyMemoryBeanPanel);
        this._copyLocalVariableTextField = new JTextField(30);
        this._copyVariable.add(this._copyLocalVariableTextField);
        this._copyTableCellTextField = new JTextField(30);
        this._copyTableCell.add(this._copyTableCellTextField);
        this._calculateFormulaTextField = new JTextField(30);
        this._calculateFormula.add(this._calculateFormulaTextField);
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPaneMemory.setSelectedComponent(this._panelMemoryDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneMemory.setSelectedComponent(this._panelMemoryReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneMemory.setSelectedComponent(this._panelMemoryLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneMemory.setSelectedComponent(this._panelMemoryFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getMemory() != null) {
                this._memoryBeanPanel.setDefaultNamedBean(action.getMemory().getBean());
            }
            this._memoryReferenceTextField.setText(action.getReference());
            this._memoryLocalVariableTextField.setText(action.getLocalVariable());
            this._memoryFormulaTextField.setText(action.getFormula());
            if (action.getOtherMemory() != null) {
                this._copyMemoryBeanPanel.setDefaultNamedBean(action.getOtherMemory().getBean());
            }
            switch (action.getMemoryOperation()) {
                case SetToNull: {
                    this._tabbedPaneMemoryOperation.setSelectedComponent(this._setToNull);
                    break;
                }
                case SetToString: {
                    this._tabbedPaneMemoryOperation.setSelectedComponent(this._setToConstant);
                    break;
                }
                case CopyMemoryToMemory: {
                    this._tabbedPaneMemoryOperation.setSelectedComponent(this._copyMemory);
                    break;
                }
                case CopyTableCellToMemory: {
                    this._tabbedPaneMemoryOperation.setSelectedComponent(this._copyTableCell);
                    break;
                }
                case CopyVariableToMemory: {
                    this._tabbedPaneMemoryOperation.setSelectedComponent(this._copyVariable);
                    break;
                }
                case CalculateFormula: {
                    this._tabbedPaneMemoryOperation.setSelectedComponent(this._calculateFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getMemoryOperation().name());
                }
            }
            this._setToConstantTextField.setText(action.getConstantValue());
            this._copyTableCellTextField.setText(ActionMemory.convertTableReference(action.getOtherTableCell(), false));
            this._copyLocalVariableTextField.setText(action.getOtherLocalVariable());
            this._calculateFormulaTextField.setText(action.getOtherFormula());
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneMemory, this._tabbedPaneMemoryOperation};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionMemory_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        this.validateMemorySection(errorMessages);
        this.validateDataSection(errorMessages);
        return errorMessages.isEmpty();
    }

    private void validateMemorySection(@Nonnull List<String> errorMessages) {
        block10: {
            ActionMemory action = new ActionMemory("IQDA1", null);
            if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryDirect && this._memoryBeanPanel.getNamedBean() == null) {
                errorMessages.add(Bundle.getMessage("ActionMemory_ErrorMemory"));
            }
            try {
                if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryReference) {
                    action.setReference(this._memoryReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
            }
            try {
                action.setFormula(this._memoryFormulaTextField.getText());
                if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                    break block10;
                }
                if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    break block10;
                }
                if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block10;
                }
                if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    break block10;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
    }

    public void validateDataSection(@Nonnull List<String> errorMessages) {
        ActionMemory action = new ActionMemory("IQDA2", null);
        if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._copyMemory && this._copyMemoryBeanPanel.getNamedBean() == null) {
            errorMessages.add(Bundle.getMessage("ActionMemory_CopyErrorMemory"));
        }
        try {
            if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._copyTableCell) {
                action.setOtherTableCell(ActionMemory.convertTableReference(this._copyTableCellTextField.getText(), true));
            }
        }
        catch (IllegalArgumentException e) {
            errorMessages.add(e.getMessage());
            return;
        }
        try {
            action.setOtherFormula(this._calculateFormulaTextField.getText());
            if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._calculateFormula) {
                action.setMemoryOperation(ActionMemory.MemoryOperation.CalculateFormula);
            }
        }
        catch (ParserException e) {
            errorMessages.add("Cannot parse formula: " + e.getMessage());
        }
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionMemory action = new ActionMemory(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block23: {
            if (!(object instanceof ActionMemory)) {
                throw new IllegalArgumentException("object must be an ActionMemory but is a: " + object.getClass().getName());
            }
            ActionMemory action = (ActionMemory)object;
            Memory memory = this._memoryBeanPanel.getNamedBean();
            if (memory != null) {
                NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
                action.setMemory(handle);
            } else {
                action.removeMemory();
            }
            if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._copyMemory) {
                Memory otherMemory = this._copyMemoryBeanPanel.getNamedBean();
                if (otherMemory != null) {
                    NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(otherMemory.getDisplayName(), otherMemory);
                    action.setOtherMemory(handle);
                } else {
                    action.removeOtherMemory();
                }
            } else {
                action.removeOtherMemory();
            }
            try {
                if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._memoryReferenceTextField.getText());
                } else if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._memoryLocalVariableTextField.getText());
                } else if (this._tabbedPaneMemory.getSelectedComponent() == this._panelMemoryFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._memoryFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneMemory has unknown selection");
                }
                if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._setToNull) {
                    action.setMemoryOperation(ActionMemory.MemoryOperation.SetToNull);
                    break block23;
                }
                if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._setToConstant) {
                    action.setMemoryOperation(ActionMemory.MemoryOperation.SetToString);
                    action.setOtherConstantValue(this._setToConstantTextField.getText());
                    break block23;
                }
                if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._copyMemory) {
                    action.setMemoryOperation(ActionMemory.MemoryOperation.CopyMemoryToMemory);
                    break block23;
                }
                if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._copyTableCell) {
                    action.setMemoryOperation(ActionMemory.MemoryOperation.CopyTableCellToMemory);
                    action.setOtherTableCell(ActionMemory.convertTableReference(this._copyTableCellTextField.getText(), true));
                    break block23;
                }
                if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._copyVariable) {
                    action.setMemoryOperation(ActionMemory.MemoryOperation.CopyVariableToMemory);
                    action.setOtherLocalVariable(this._copyLocalVariableTextField.getText());
                    break block23;
                }
                if (this._tabbedPaneMemoryOperation.getSelectedComponent() == this._calculateFormula) {
                    action.setMemoryOperation(ActionMemory.MemoryOperation.CalculateFormula);
                    action.setOtherFormula(this._calculateFormulaTextField.getText());
                    break block23;
                }
                throw new IllegalArgumentException("_tabbedPaneMemoryOperation has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionMemory_Short");
    }

    @Override
    public void dispose() {
    }
}

