/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionLocalVariable;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.BeanSelectPanel;

public class ActionLocalVariableSwing
extends AbstractDigitalActionSwing {
    private JTextField _localVariableTextField;
    private JTabbedPane _tabbedPaneVariableOperation;
    private BeanSelectPanel<Memory> _copyMemoryBeanPanel;
    private JPanel _setToNull;
    private JPanel _setToConstant;
    private JPanel _copyMemory;
    private JPanel _copyVariable;
    private JPanel _calculateFormula;
    private JPanel _copyTableCell;
    private JTextField _setToConstantTextField;
    private JTextField _copyLocalVariableTextField;
    private JTextField _calculateFormulaTextField;
    private JTextField _copyTableCellTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionLocalVariable action = (ActionLocalVariable)object;
        this.panel = new JPanel();
        this._localVariableTextField = new JTextField(20);
        this._tabbedPaneVariableOperation = new JTabbedPane();
        this._setToNull = new JPanel();
        this._setToConstant = new JPanel();
        this._copyMemory = new JPanel();
        this._copyTableCell = new JPanel();
        this._copyVariable = new JPanel();
        this._calculateFormula = new JPanel();
        this._tabbedPaneVariableOperation.addTab(ActionLocalVariable.VariableOperation.SetToNull.toString(), this._setToNull);
        this._tabbedPaneVariableOperation.addTab(ActionLocalVariable.VariableOperation.SetToString.toString(), this._setToConstant);
        this._tabbedPaneVariableOperation.addTab(ActionLocalVariable.VariableOperation.CopyMemoryToVariable.toString(), this._copyMemory);
        this._tabbedPaneVariableOperation.addTab(ActionLocalVariable.VariableOperation.CopyTableCellToVariable.toString(), this._copyTableCell);
        this._tabbedPaneVariableOperation.addTab(ActionLocalVariable.VariableOperation.CopyVariableToVariable.toString(), this._copyVariable);
        this._tabbedPaneVariableOperation.addTab(ActionLocalVariable.VariableOperation.CalculateFormula.toString(), this._calculateFormula);
        this._setToNull.add(new JLabel("Null"));
        this._setToConstantTextField = new JTextField(30);
        this._setToConstant.add(this._setToConstantTextField);
        this._copyMemoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._copyMemory.add(this._copyMemoryBeanPanel);
        this._copyTableCellTextField = new JTextField(30);
        this._copyTableCell.add(this._copyTableCellTextField);
        this._copyLocalVariableTextField = new JTextField(30);
        this._copyVariable.add(this._copyLocalVariableTextField);
        this._calculateFormulaTextField = new JTextField(30);
        this._calculateFormula.add(this._calculateFormulaTextField);
        if (action != null) {
            if (action.getLocalVariable() != null) {
                this._localVariableTextField.setText(action.getLocalVariable());
            }
            if (action.getMemory() != null) {
                this._copyMemoryBeanPanel.setDefaultNamedBean(action.getMemory().getBean());
            }
            switch (action.getVariableOperation()) {
                case SetToNull: {
                    this._tabbedPaneVariableOperation.setSelectedComponent(this._setToNull);
                    break;
                }
                case SetToString: {
                    this._tabbedPaneVariableOperation.setSelectedComponent(this._setToConstant);
                    break;
                }
                case CopyMemoryToVariable: {
                    this._tabbedPaneVariableOperation.setSelectedComponent(this._copyMemory);
                    break;
                }
                case CopyTableCellToVariable: {
                    this._tabbedPaneVariableOperation.setSelectedComponent(this._copyTableCell);
                    break;
                }
                case CopyVariableToVariable: {
                    this._tabbedPaneVariableOperation.setSelectedComponent(this._copyVariable);
                    break;
                }
                case CalculateFormula: {
                    this._tabbedPaneVariableOperation.setSelectedComponent(this._calculateFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getVariableOperation().name());
                }
            }
            this._setToConstantTextField.setText(action.getConstantValue());
            this._copyTableCellTextField.setText(ActionLocalVariable.convertTableReference(action.getOtherTableCell(), false));
            this._copyLocalVariableTextField.setText(action.getOtherLocalVariable());
            this._calculateFormulaTextField.setText(action.getFormula());
        }
        JComponent[] components = new JComponent[]{this._localVariableTextField, this._tabbedPaneVariableOperation};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionLocalVariable_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionLocalVariable action = new ActionLocalVariable("IQDA1", null);
        if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._copyMemory && this._copyMemoryBeanPanel.getNamedBean() == null) {
            errorMessages.add(Bundle.getMessage("ActionLocalVariable_CopyErrorMemory"));
        }
        try {
            if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._copyTableCell) {
                action.setOtherTableCell(ActionLocalVariable.convertTableReference(this._copyTableCellTextField.getText(), true));
            }
        }
        catch (IllegalArgumentException e) {
            errorMessages.add(e.getMessage());
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionLocalVariable action = new ActionLocalVariable(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block10: {
            Memory otherMemory;
            if (!(object instanceof ActionLocalVariable)) {
                throw new IllegalArgumentException("object must be an ActionLocalVariable but is a: " + object.getClass().getName());
            }
            ActionLocalVariable action = (ActionLocalVariable)object;
            action.setLocalVariable(this._localVariableTextField.getText());
            if (!this._copyMemoryBeanPanel.isEmpty() && this._tabbedPaneVariableOperation.getSelectedComponent() == this._copyMemory && (otherMemory = this._copyMemoryBeanPanel.getNamedBean()) != null) {
                NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(otherMemory.getDisplayName(), otherMemory);
                action.setMemory(handle);
            }
            try {
                if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._setToNull) {
                    action.setVariableOperation(ActionLocalVariable.VariableOperation.SetToNull);
                    break block10;
                }
                if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._setToConstant) {
                    action.setVariableOperation(ActionLocalVariable.VariableOperation.SetToString);
                    action.setConstantValue(this._setToConstantTextField.getText());
                    break block10;
                }
                if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._copyMemory) {
                    action.setVariableOperation(ActionLocalVariable.VariableOperation.CopyMemoryToVariable);
                    break block10;
                }
                if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._copyTableCell) {
                    action.setVariableOperation(ActionLocalVariable.VariableOperation.CopyTableCellToVariable);
                    action.setOtherTableCell(ActionLocalVariable.convertTableReference(this._copyTableCellTextField.getText(), true));
                    break block10;
                }
                if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._copyVariable) {
                    action.setVariableOperation(ActionLocalVariable.VariableOperation.CopyVariableToVariable);
                    action.setOtherLocalVariable(this._copyLocalVariableTextField.getText());
                    break block10;
                }
                if (this._tabbedPaneVariableOperation.getSelectedComponent() == this._calculateFormula) {
                    action.setVariableOperation(ActionLocalVariable.VariableOperation.CalculateFormula);
                    action.setFormula(this._calculateFormulaTextField.getText());
                    break block10;
                }
                throw new IllegalArgumentException("_tabbedPaneVariableOperation has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionLocalVariable_Short");
    }

    @Override
    public void dispose() {
    }
}

