/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionLight;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class ActionLightSwing
extends AbstractDigitalActionSwing {
    private JTabbedPane _tabbedPaneLight;
    private BeanSelectPanel<Light> lightBeanPanel;
    private JPanel _panelLightDirect;
    private JPanel _panelLightReference;
    private JPanel _panelLightLocalVariable;
    private JPanel _panelLightFormula;
    private JTextField _lightReferenceTextField;
    private JTextField _lightLocalVariableTextField;
    private JTextField _lightFormulaTextField;
    private JTabbedPane _tabbedPaneLightState;
    private JComboBox<ActionLight.LightState> _stateComboBox;
    private JPanel _panelLightStateDirect;
    private JPanel _panelLightStateReference;
    private JPanel _panelLightStateLocalVariable;
    private JPanel _panelLightStateFormula;
    private JTextField _lightStateReferenceTextField;
    private JTextField _lightStateLocalVariableTextField;
    private JTextField _lightStateFormulaTextField;
    private JTabbedPane _tabbedPaneData;
    private JPanel _panelDataDirect;
    private JPanel _panelDataReference;
    private JPanel _panelDataLocalVariable;
    private JPanel _panelDataFormula;
    private JTextField _lightDataDirectTextField;
    private JTextField _lightDataReferenceTextField;
    private JTextField _lightDataLocalVariableTextField;
    private JTextField _lightDataFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionLight action = (ActionLight)object;
        this.panel = new JPanel();
        this._tabbedPaneLight = new JTabbedPane();
        this._panelLightDirect = new JPanel();
        this._panelLightReference = new JPanel();
        this._panelLightLocalVariable = new JPanel();
        this._panelLightFormula = new JPanel();
        this._tabbedPaneLight.addTab(NamedBeanAddressing.Direct.toString(), this._panelLightDirect);
        this._tabbedPaneLight.addTab(NamedBeanAddressing.Reference.toString(), this._panelLightReference);
        this._tabbedPaneLight.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLightLocalVariable);
        this._tabbedPaneLight.addTab(NamedBeanAddressing.Formula.toString(), this._panelLightFormula);
        this.lightBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(LightManager.class), null);
        this._panelLightDirect.add(this.lightBeanPanel);
        this._lightReferenceTextField = new JTextField();
        this._lightReferenceTextField.setColumns(30);
        this._panelLightReference.add(this._lightReferenceTextField);
        this._lightLocalVariableTextField = new JTextField();
        this._lightLocalVariableTextField.setColumns(30);
        this._panelLightLocalVariable.add(this._lightLocalVariableTextField);
        this._lightFormulaTextField = new JTextField();
        this._lightFormulaTextField.setColumns(30);
        this._panelLightFormula.add(this._lightFormulaTextField);
        this._tabbedPaneLightState = new JTabbedPane();
        this._panelLightStateDirect = new JPanel();
        this._panelLightStateReference = new JPanel();
        this._panelLightStateLocalVariable = new JPanel();
        this._panelLightStateFormula = new JPanel();
        this._tabbedPaneLightState.addTab(NamedBeanAddressing.Direct.toString(), this._panelLightStateDirect);
        this._tabbedPaneLightState.addTab(NamedBeanAddressing.Reference.toString(), this._panelLightStateReference);
        this._tabbedPaneLightState.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLightStateLocalVariable);
        this._tabbedPaneLightState.addTab(NamedBeanAddressing.Formula.toString(), this._panelLightStateFormula);
        this._stateComboBox = new JComboBox();
        ActionLight.LightState[] lightStateArray = ActionLight.LightState.values();
        int n = lightStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionLight.LightState e2 = lightStateArray[n2];
            this._stateComboBox.addItem(e2);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._stateComboBox);
        this._stateComboBox.addActionListener(e -> this.setDataPanelState());
        this._panelLightStateDirect.add(this._stateComboBox);
        this._lightStateReferenceTextField = new JTextField();
        this._lightStateReferenceTextField.setColumns(30);
        this._panelLightStateReference.add(this._lightStateReferenceTextField);
        this._lightStateLocalVariableTextField = new JTextField();
        this._lightStateLocalVariableTextField.setColumns(30);
        this._panelLightStateLocalVariable.add(this._lightStateLocalVariableTextField);
        this._lightStateFormulaTextField = new JTextField();
        this._lightStateFormulaTextField.setColumns(30);
        this._panelLightStateFormula.add(this._lightStateFormulaTextField);
        this._tabbedPaneData = new JTabbedPane();
        this._panelDataDirect = new JPanel();
        this._panelDataReference = new JPanel();
        this._panelDataLocalVariable = new JPanel();
        this._panelDataFormula = new JPanel();
        this._tabbedPaneData.addTab(NamedBeanAddressing.Direct.toString(), this._panelDataDirect);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Reference.toString(), this._panelDataReference);
        this._tabbedPaneData.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelDataLocalVariable);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Formula.toString(), this._panelDataFormula);
        this._lightDataDirectTextField = new JTextField();
        this._lightDataDirectTextField.setColumns(30);
        this._panelDataDirect.add(this._lightDataDirectTextField);
        this._lightDataReferenceTextField = new JTextField();
        this._lightDataReferenceTextField.setColumns(30);
        this._panelDataReference.add(this._lightDataReferenceTextField);
        this._lightDataLocalVariableTextField = new JTextField();
        this._lightDataLocalVariableTextField.setColumns(30);
        this._panelDataLocalVariable.add(this._lightDataLocalVariableTextField);
        this._lightDataFormulaTextField = new JTextField();
        this._lightDataFormulaTextField.setColumns(30);
        this._panelDataFormula.add(this._lightDataFormulaTextField);
        this.setDataPanelState();
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPaneLight.setSelectedComponent(this._panelLightDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneLight.setSelectedComponent(this._panelLightReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneLight.setSelectedComponent(this._panelLightLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneLight.setSelectedComponent(this._panelLightFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getLight() != null) {
                this.lightBeanPanel.setDefaultNamedBean(action.getLight().getBean());
            }
            this._lightReferenceTextField.setText(action.getReference());
            this._lightLocalVariableTextField.setText(action.getLocalVariable());
            this._lightFormulaTextField.setText(action.getFormula());
            switch (action.getStateAddressing()) {
                case Direct: {
                    this._tabbedPaneLightState.setSelectedComponent(this._panelLightStateDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneLightState.setSelectedComponent(this._panelLightStateReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneLightState.setSelectedComponent(this._panelLightStateLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneLightState.setSelectedComponent(this._panelLightStateFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            this._stateComboBox.setSelectedItem((Object)action.getBeanState());
            this._lightStateReferenceTextField.setText(action.getStateReference());
            this._lightStateLocalVariableTextField.setText(action.getStateLocalVariable());
            this._lightStateFormulaTextField.setText(action.getStateFormula());
            switch (action.getDataAddressing()) {
                case Direct: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getDataAddressing().name());
                }
            }
            this._lightDataReferenceTextField.setText(action.getDataReference());
            this._lightDataLocalVariableTextField.setText(action.getDataLocalVariable());
            this._lightDataFormulaTextField.setText(action.getDataFormula());
            this._lightDataDirectTextField.setText(Integer.toString(action.getLightValue()));
            this.setDataPanelState();
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneLight, this._tabbedPaneLightState, this._tabbedPaneData};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionLight_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void setDataPanelState() {
        boolean newState = this._stateComboBox.getSelectedItem() == ActionLight.LightState.Intensity || this._stateComboBox.getSelectedItem() == ActionLight.LightState.Interval;
        this._tabbedPaneData.setEnabled(newState);
        this._lightDataDirectTextField.setEnabled(newState);
        this._lightDataReferenceTextField.setEnabled(newState);
        this._lightDataLocalVariableTextField.setEnabled(newState);
        this._lightDataFormulaTextField.setEnabled(newState);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block33: {
            ActionLight action;
            block32: {
                action = new ActionLight("IQDA1", null);
                try {
                    if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightReference) {
                        action.setReference(this._lightReferenceTextField.getText());
                    }
                }
                catch (IllegalArgumentException e) {
                    errorMessages.add(e.getMessage());
                    return false;
                }
                try {
                    if (this._tabbedPaneLightState.getSelectedComponent() == this._panelLightStateReference) {
                        action.setStateReference(this._lightStateReferenceTextField.getText());
                    }
                }
                catch (IllegalArgumentException e) {
                    errorMessages.add(e.getMessage());
                    return false;
                }
                try {
                    action.setFormula(this._lightFormulaTextField.getText());
                    if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightDirect) {
                        action.setAddressing(NamedBeanAddressing.Direct);
                        break block32;
                    }
                    if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightReference) {
                        action.setAddressing(NamedBeanAddressing.Reference);
                        break block32;
                    }
                    if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightLocalVariable) {
                        action.setAddressing(NamedBeanAddressing.LocalVariable);
                        break block32;
                    }
                    if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightFormula) {
                        action.setAddressing(NamedBeanAddressing.Formula);
                        break block32;
                    }
                    throw new IllegalArgumentException("_tabbedPane has unknown selection");
                }
                catch (ParserException e) {
                    errorMessages.add("Cannot parse formula: " + e.getMessage());
                }
            }
            try {
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataReference(this._lightDataReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setDataFormula(this._lightDataFormulaTextField.getText());
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    break block33;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    break block33;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    break block33;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    break block33;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
            int value;
            boolean result;
            ActionLight.LightState oper = this._stateComboBox.getItemAt(this._stateComboBox.getSelectedIndex());
            if (oper == ActionLight.LightState.Intensity) {
                result = true;
                try {
                    value = Integer.parseInt(this._lightDataDirectTextField.getText());
                    if (value < 0 || value > 100) {
                        result = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result = false;
                }
                if (!result) {
                    errorMessages.add(Bundle.getMessage("Light_Error_Intensity"));
                    return false;
                }
            }
            if (oper == ActionLight.LightState.Interval) {
                result = true;
                try {
                    value = Integer.parseInt(this._lightDataDirectTextField.getText());
                    if (value < 0) {
                        result = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result = false;
                }
                if (!result) {
                    errorMessages.add(Bundle.getMessage("Light_Error_Interval"));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionLight action = new ActionLight(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block31: {
            if (!(object instanceof ActionLight)) {
                throw new IllegalArgumentException("object must be an ActionLight but is a: " + object.getClass().getName());
            }
            ActionLight action = (ActionLight)object;
            if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightDirect) {
                if (this.lightBeanPanel != null) {
                    Light light = this.lightBeanPanel.getNamedBean();
                    if (light != null) {
                        NamedBeanHandle<Light> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(light.getDisplayName(), light);
                        action.setLight(handle);
                    } else {
                        action.removeLight();
                    }
                } else {
                    action.removeLight();
                }
            } else {
                action.removeLight();
            }
            try {
                if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._lightReferenceTextField.getText());
                } else if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._lightLocalVariableTextField.getText());
                } else if (this._tabbedPaneLight.getSelectedComponent() == this._panelLightFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._lightFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneLight has unknown selection");
                }
                if (this._tabbedPaneLightState.getSelectedComponent() == this._panelLightStateDirect) {
                    action.setStateAddressing(NamedBeanAddressing.Direct);
                    action.setBeanState(this._stateComboBox.getItemAt(this._stateComboBox.getSelectedIndex()));
                } else if (this._tabbedPaneLightState.getSelectedComponent() == this._panelLightStateReference) {
                    action.setStateAddressing(NamedBeanAddressing.Reference);
                    action.setStateReference(this._lightStateReferenceTextField.getText());
                } else if (this._tabbedPaneLightState.getSelectedComponent() == this._panelLightStateLocalVariable) {
                    action.setStateAddressing(NamedBeanAddressing.LocalVariable);
                    action.setStateLocalVariable(this._lightStateLocalVariableTextField.getText());
                } else if (this._tabbedPaneLightState.getSelectedComponent() == this._panelLightStateFormula) {
                    action.setStateAddressing(NamedBeanAddressing.Formula);
                    action.setStateFormula(this._lightStateFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneLightState has unknown selection");
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    int value;
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    if (action.getBeanState() != ActionLight.LightState.Intensity && action.getBeanState() != ActionLight.LightState.Interval) break block31;
                    try {
                        value = Integer.parseInt(this._lightDataDirectTextField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        value = 0;
                    }
                    action.setLightValue(value);
                    break block31;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    action.setDataReference(this._lightDataReferenceTextField.getText());
                    break block31;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    action.setDataLocalVariable(this._lightDataLocalVariableTextField.getText());
                    break block31;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    action.setDataFormula(this._lightDataFormulaTextField.getText());
                    break block31;
                }
                throw new IllegalArgumentException("_tabbedPaneData has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Light_Short");
    }

    @Override
    public void dispose() {
        if (this.lightBeanPanel != null) {
            this.lightBeanPanel.dispose();
        }
    }
}

