/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionClock;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.util.swing.JComboBoxUtil;

public class ActionClockSwing
extends AbstractDigitalActionSwing {
    private JComboBox<ActionClock.ClockState> _stateComboBox;
    private JTextField _timeTextField;
    private int _minutes = 0;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionClock action = (ActionClock)object;
        this.panel = new JPanel();
        this._stateComboBox = new JComboBox();
        ActionClock.ClockState[] clockStateArray = ActionClock.ClockState.values();
        int n = clockStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionClock.ClockState e2 = clockStateArray[n2];
            this._stateComboBox.addItem(e2);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._stateComboBox);
        this._stateComboBox.addActionListener(e -> this.setTimeField(action == null ? 0 : action.getClockTime()));
        this._timeTextField = new JTextField(4);
        this.setTimeField(0);
        if (action != null) {
            this._stateComboBox.setSelectedItem((Object)action.getBeanState());
            this.setTimeField(action.getClockTime());
        }
        JPanel timeField = new JPanel();
        JLabel timelabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ActionClock_TimeLabel")));
        timeField.add(timelabel);
        timeField.add(this._timeTextField);
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this._stateComboBox);
        container.add(timeField);
        JComponent[] components = new JComponent[]{container};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionClock_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void setTimeField(int time) {
        if (this._stateComboBox.getSelectedItem() == ActionClock.ClockState.SetClock) {
            this._timeTextField.setEnabled(true);
            this._timeTextField.setText(ActionClock.formatTime(time));
        } else {
            this._timeTextField.setEnabled(false);
            this._timeTextField.setText("");
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        if (this._stateComboBox.getSelectedItem() == ActionClock.ClockState.SetClock) {
            try {
                LocalTime newHHMM = LocalTime.parse(this._timeTextField.getText().trim(), DateTimeFormatter.ofPattern("H:mm"));
                this._minutes = newHHMM.getHour() * 60 + newHHMM.getMinute();
                if (this._minutes < 0 || this._minutes > 1439) {
                    errorMessages.add(Bundle.getMessage("ActionClock_RangeError"));
                }
            }
            catch (DateTimeParseException ex) {
                errorMessages.add(Bundle.getMessage("ActionClock_ParseError", ex.getParsedString()));
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public String getAutoSystemName() {
        return InstanceManager.getDefault(DigitalActionManager.class).getAutoSystemName();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionClock action = new ActionClock(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionClock)) {
            throw new IllegalArgumentException("object must be an ActionClock but is a: " + object.getClass().getName());
        }
        ActionClock action = (ActionClock)object;
        action.setBeanState(this._stateComboBox.getItemAt(this._stateComboBox.getSelectedIndex()));
        if (this._stateComboBox.getSelectedItem() == ActionClock.ClockState.SetClock) {
            action.setClockTime(this._minutes);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionClock_Short");
    }

    @Override
    public void dispose() {
    }
}

