/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionBlock;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class ActionBlockSwing
extends AbstractDigitalActionSwing {
    private JTabbedPane _tabbedPaneBlock;
    private BeanSelectPanel<Block> _blockBeanPanel;
    private JPanel _panelBlockDirect;
    private JPanel _panelBlockReference;
    private JPanel _panelBlockLocalVariable;
    private JPanel _panelBlockFormula;
    private JTextField _blockReferenceTextField;
    private JTextField _blockLocalVariableTextField;
    private JTextField _blockFormulaTextField;
    private JTabbedPane _tabbedPaneOperation;
    private JComboBox<ActionBlock.DirectOperation> _stateComboBox;
    private JPanel _panelOperationDirect;
    private JPanel _panelOperationReference;
    private JPanel _panelOperationLocalVariable;
    private JPanel _panelOperationFormula;
    private JTextField _blockOperReferenceTextField;
    private JTextField _blockOperLocalVariableTextField;
    private JTextField _blockOperFormulaTextField;
    private JTabbedPane _tabbedPaneData;
    private JPanel _panelDataDirect;
    private JPanel _panelDataReference;
    private JPanel _panelDataLocalVariable;
    private JPanel _panelDataFormula;
    private JTextField _blockDataDirectTextField;
    private JTextField _blockDataReferenceTextField;
    private JTextField _blockDataLocalVariableTextField;
    private JTextField _blockDataFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionBlock action = (ActionBlock)object;
        this.panel = new JPanel();
        this._tabbedPaneBlock = new JTabbedPane();
        this._panelBlockDirect = new JPanel();
        this._panelBlockReference = new JPanel();
        this._panelBlockLocalVariable = new JPanel();
        this._panelBlockFormula = new JPanel();
        this._tabbedPaneBlock.addTab(NamedBeanAddressing.Direct.toString(), this._panelBlockDirect);
        this._tabbedPaneBlock.addTab(NamedBeanAddressing.Reference.toString(), this._panelBlockReference);
        this._tabbedPaneBlock.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelBlockLocalVariable);
        this._tabbedPaneBlock.addTab(NamedBeanAddressing.Formula.toString(), this._panelBlockFormula);
        this._blockBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(BlockManager.class), null);
        this._panelBlockDirect.add(this._blockBeanPanel);
        this._blockReferenceTextField = new JTextField();
        this._blockReferenceTextField.setColumns(30);
        this._panelBlockReference.add(this._blockReferenceTextField);
        this._blockLocalVariableTextField = new JTextField();
        this._blockLocalVariableTextField.setColumns(30);
        this._panelBlockLocalVariable.add(this._blockLocalVariableTextField);
        this._blockFormulaTextField = new JTextField();
        this._blockFormulaTextField.setColumns(30);
        this._panelBlockFormula.add(this._blockFormulaTextField);
        this._tabbedPaneOperation = new JTabbedPane();
        this._panelOperationDirect = new JPanel();
        this._panelOperationReference = new JPanel();
        this._panelOperationLocalVariable = new JPanel();
        this._panelOperationFormula = new JPanel();
        this._tabbedPaneOperation.addTab(NamedBeanAddressing.Direct.toString(), this._panelOperationDirect);
        this._tabbedPaneOperation.addTab(NamedBeanAddressing.Reference.toString(), this._panelOperationReference);
        this._tabbedPaneOperation.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelOperationLocalVariable);
        this._tabbedPaneOperation.addTab(NamedBeanAddressing.Formula.toString(), this._panelOperationFormula);
        this._stateComboBox = new JComboBox();
        ActionBlock.DirectOperation[] directOperationArray = ActionBlock.DirectOperation.values();
        int n = directOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionBlock.DirectOperation e2 = directOperationArray[n2];
            this._stateComboBox.addItem(e2);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._stateComboBox);
        this._stateComboBox.addActionListener(e -> this.setDataPanelState());
        this._panelOperationDirect.add(this._stateComboBox);
        this._blockOperReferenceTextField = new JTextField();
        this._blockOperReferenceTextField.setColumns(30);
        this._panelOperationReference.add(this._blockOperReferenceTextField);
        this._blockOperLocalVariableTextField = new JTextField();
        this._blockOperLocalVariableTextField.setColumns(30);
        this._panelOperationLocalVariable.add(this._blockOperLocalVariableTextField);
        this._blockOperFormulaTextField = new JTextField();
        this._blockOperFormulaTextField.setColumns(30);
        this._panelOperationFormula.add(this._blockOperFormulaTextField);
        this._tabbedPaneData = new JTabbedPane();
        this._panelDataDirect = new JPanel();
        this._panelDataReference = new JPanel();
        this._panelDataLocalVariable = new JPanel();
        this._panelDataFormula = new JPanel();
        this._tabbedPaneData.addTab(NamedBeanAddressing.Direct.toString(), this._panelDataDirect);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Reference.toString(), this._panelDataReference);
        this._tabbedPaneData.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelDataLocalVariable);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Formula.toString(), this._panelDataFormula);
        this._blockDataDirectTextField = new JTextField();
        this._blockDataDirectTextField.setColumns(30);
        this._panelDataDirect.add(this._blockDataDirectTextField);
        this._blockDataReferenceTextField = new JTextField();
        this._blockDataReferenceTextField.setColumns(30);
        this._panelDataReference.add(this._blockDataReferenceTextField);
        this._blockDataLocalVariableTextField = new JTextField();
        this._blockDataLocalVariableTextField.setColumns(30);
        this._panelDataLocalVariable.add(this._blockDataLocalVariableTextField);
        this._blockDataFormulaTextField = new JTextField();
        this._blockDataFormulaTextField.setColumns(30);
        this._panelDataFormula.add(this._blockDataFormulaTextField);
        this.setDataPanelState();
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPaneBlock.setSelectedComponent(this._panelBlockDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneBlock.setSelectedComponent(this._panelBlockReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneBlock.setSelectedComponent(this._panelBlockLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneBlock.setSelectedComponent(this._panelBlockFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getBlock() != null) {
                this._blockBeanPanel.setDefaultNamedBean(action.getBlock().getBean());
            }
            this._blockReferenceTextField.setText(action.getReference());
            this._blockLocalVariableTextField.setText(action.getLocalVariable());
            this._blockFormulaTextField.setText(action.getFormula());
            switch (action.getOperationAddressing()) {
                case Direct: {
                    this._tabbedPaneOperation.setSelectedComponent(this._panelOperationDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneOperation.setSelectedComponent(this._panelOperationReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneOperation.setSelectedComponent(this._panelOperationLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneOperation.setSelectedComponent(this._panelOperationFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getOperationAddressing().name());
                }
            }
            this._stateComboBox.setSelectedItem((Object)action.getOperationDirect());
            this._blockOperReferenceTextField.setText(action.getOperationReference());
            this._blockOperLocalVariableTextField.setText(action.getOperationLocalVariable());
            this._blockOperFormulaTextField.setText(action.getOperationFormula());
            switch (action.getDataAddressing()) {
                case Direct: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getDataAddressing().name());
                }
            }
            this._blockDataReferenceTextField.setText(action.getDataReference());
            this._blockDataLocalVariableTextField.setText(action.getDataLocalVariable());
            this._blockDataFormulaTextField.setText(action.getDataFormula());
            this._blockDataDirectTextField.setText(action.getBlockValue());
            this.setDataPanelState();
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneBlock, this._tabbedPaneOperation, this._tabbedPaneData};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionBlock_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void setDataPanelState() {
        boolean newState = this._stateComboBox.getSelectedItem() == ActionBlock.DirectOperation.SetValue;
        this._tabbedPaneData.setEnabled(newState);
        this._blockDataDirectTextField.setEnabled(newState);
        this._blockDataReferenceTextField.setEnabled(newState);
        this._blockDataLocalVariableTextField.setEnabled(newState);
        this._blockDataFormulaTextField.setEnabled(newState);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        this.validateBlockSection(errorMessages);
        this.validateOperationSection(errorMessages);
        this.validateDataSection(errorMessages);
        return errorMessages.isEmpty();
    }

    private void validateBlockSection(List<String> errorMessages) {
        block10: {
            ActionBlock action = new ActionBlock("IQDA1", null);
            try {
                if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockReference) {
                    action.setReference(this._blockReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return;
            }
            try {
                action.setFormula(this._blockFormulaTextField.getText());
                if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                    break block10;
                }
                if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    break block10;
                }
                if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block10;
                }
                if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    break block10;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockDirect && this._blockBeanPanel.getNamedBean() == null) {
            errorMessages.add(Bundle.getMessage("ActionBlock_ErrorBlock"));
        }
    }

    private void validateOperationSection(List<String> errorMessages) {
        block9: {
            ActionBlock action = new ActionBlock("IQDA2", null);
            try {
                if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationReference) {
                    action.setOperationReference(this._blockOperReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return;
            }
            try {
                action.setOperationFormula(this._blockOperFormulaTextField.getText());
                if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationDirect) {
                    action.setOperationAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationReference) {
                    action.setOperationAddressing(NamedBeanAddressing.Reference);
                    break block9;
                }
                if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationLocalVariable) {
                    action.setOperationAddressing(NamedBeanAddressing.LocalVariable);
                    break block9;
                }
                if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationFormula) {
                    action.setOperationAddressing(NamedBeanAddressing.Formula);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
    }

    private void validateDataSection(List<String> errorMessages) {
        ActionBlock.DirectOperation oper;
        block10: {
            ActionBlock action = new ActionBlock("IQDA3", null);
            try {
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataReference(this._blockDataReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return;
            }
            try {
                action.setDataFormula(this._blockDataFormulaTextField.getText());
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    break block10;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    break block10;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    break block10;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    break block10;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect && (oper = this._stateComboBox.getItemAt(this._stateComboBox.getSelectedIndex())) == ActionBlock.DirectOperation.SetValue && this._blockDataDirectTextField.getText().isEmpty()) {
            errorMessages.add(Bundle.getMessage("ActionBlock_ErrorValue"));
        }
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionBlock action = new ActionBlock(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block28: {
            if (!(object instanceof ActionBlock)) {
                throw new IllegalArgumentException("object must be an ActionBlock but is a: " + object.getClass().getName());
            }
            ActionBlock action = (ActionBlock)object;
            if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockDirect) {
                Block block = this._blockBeanPanel.getNamedBean();
                if (block != null) {
                    NamedBeanHandle<Block> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(block.getDisplayName(), block);
                    action.setBlock(handle);
                } else {
                    action.removeBlock();
                }
            } else {
                action.removeBlock();
            }
            try {
                if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._blockReferenceTextField.getText());
                } else if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._blockLocalVariableTextField.getText());
                } else if (this._tabbedPaneBlock.getSelectedComponent() == this._panelBlockFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._blockFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneBlock has unknown selection");
                }
                if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationDirect) {
                    action.setOperationAddressing(NamedBeanAddressing.Direct);
                    action.setOperationDirect(this._stateComboBox.getItemAt(this._stateComboBox.getSelectedIndex()));
                } else if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationReference) {
                    action.setOperationAddressing(NamedBeanAddressing.Reference);
                    action.setOperationReference(this._blockOperReferenceTextField.getText());
                } else if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationLocalVariable) {
                    action.setOperationAddressing(NamedBeanAddressing.LocalVariable);
                    action.setOperationLocalVariable(this._blockOperLocalVariableTextField.getText());
                } else if (this._tabbedPaneOperation.getSelectedComponent() == this._panelOperationFormula) {
                    action.setOperationAddressing(NamedBeanAddressing.Formula);
                    action.setOperationFormula(this._blockOperFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneBlock has unknown selection");
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    if (action.getOperationDirect() == ActionBlock.DirectOperation.SetValue) {
                        action.setBlockValue(this._blockDataDirectTextField.getText());
                    }
                    break block28;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    action.setDataReference(this._blockDataReferenceTextField.getText());
                    break block28;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    action.setDataLocalVariable(this._blockDataLocalVariableTextField.getText());
                    break block28;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    action.setDataFormula(this._blockDataFormulaTextField.getText());
                    break block28;
                }
                throw new IllegalArgumentException("_tabbedPaneBlock has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionBlock_Short");
    }

    @Override
    public void dispose() {
        if (this._blockBeanPanel != null) {
            this._blockBeanPanel.dispose();
        }
    }
}

