/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionAudio;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class ActionAudioSwing
extends AbstractDigitalActionSwing {
    private JTabbedPane _tabbedPaneAudio;
    private BeanSelectPanel<Audio> audioBeanPanel;
    private JPanel _panelAudioDirect;
    private JPanel _panelAudioReference;
    private JPanel _panelAudioLocalVariable;
    private JPanel _panelAudioFormula;
    private JTextField _audioReferenceTextField;
    private JTextField _audioLocalVariableTextField;
    private JTextField _audioFormulaTextField;
    private JTabbedPane _tabbedPaneAudioOperation;
    private JComboBox<ActionAudio.Operation> _operationComboBox;
    private JPanel _panelAudioOperationDirect;
    private JPanel _panelAudioOperationReference;
    private JPanel _panelAudioOperationLocalVariable;
    private JPanel _panelAudioOperationFormula;
    private JTextField _audioOperationReferenceTextField;
    private JTextField _audioOperationLocalVariableTextField;
    private JTextField _audioOperationFormulaTextField;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionAudio action = (ActionAudio)object;
        this.panel = new JPanel();
        this._tabbedPaneAudio = new JTabbedPane();
        this._panelAudioDirect = new JPanel();
        this._panelAudioReference = new JPanel();
        this._panelAudioLocalVariable = new JPanel();
        this._panelAudioFormula = new JPanel();
        this._tabbedPaneAudio.addTab(NamedBeanAddressing.Direct.toString(), this._panelAudioDirect);
        this._tabbedPaneAudio.addTab(NamedBeanAddressing.Reference.toString(), this._panelAudioReference);
        this._tabbedPaneAudio.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelAudioLocalVariable);
        this._tabbedPaneAudio.addTab(NamedBeanAddressing.Formula.toString(), this._panelAudioFormula);
        this.audioBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(AudioManager.class), null);
        this._panelAudioDirect.add(this.audioBeanPanel);
        this._audioReferenceTextField = new JTextField();
        this._audioReferenceTextField.setColumns(30);
        this._panelAudioReference.add(this._audioReferenceTextField);
        this._audioLocalVariableTextField = new JTextField();
        this._audioLocalVariableTextField.setColumns(30);
        this._panelAudioLocalVariable.add(this._audioLocalVariableTextField);
        this._audioFormulaTextField = new JTextField();
        this._audioFormulaTextField.setColumns(30);
        this._panelAudioFormula.add(this._audioFormulaTextField);
        this._tabbedPaneAudioOperation = new JTabbedPane();
        this._panelAudioOperationDirect = new JPanel();
        this._panelAudioOperationReference = new JPanel();
        this._panelAudioOperationLocalVariable = new JPanel();
        this._panelAudioOperationFormula = new JPanel();
        this._tabbedPaneAudioOperation.addTab(NamedBeanAddressing.Direct.toString(), this._panelAudioOperationDirect);
        this._tabbedPaneAudioOperation.addTab(NamedBeanAddressing.Reference.toString(), this._panelAudioOperationReference);
        this._tabbedPaneAudioOperation.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelAudioOperationLocalVariable);
        this._tabbedPaneAudioOperation.addTab(NamedBeanAddressing.Formula.toString(), this._panelAudioOperationFormula);
        this._operationComboBox = new JComboBox();
        ActionAudio.Operation[] operationArray = ActionAudio.Operation.values();
        int n = operationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionAudio.Operation e = operationArray[n2];
            this._operationComboBox.addItem(e);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._operationComboBox);
        this._panelAudioOperationDirect.add(this._operationComboBox);
        this._audioOperationReferenceTextField = new JTextField();
        this._audioOperationReferenceTextField.setColumns(30);
        this._panelAudioOperationReference.add(this._audioOperationReferenceTextField);
        this._audioOperationLocalVariableTextField = new JTextField();
        this._audioOperationLocalVariableTextField.setColumns(30);
        this._panelAudioOperationLocalVariable.add(this._audioOperationLocalVariableTextField);
        this._audioOperationFormulaTextField = new JTextField();
        this._audioOperationFormulaTextField.setColumns(30);
        this._panelAudioOperationFormula.add(this._audioOperationFormulaTextField);
        if (action != null) {
            switch (action.getAddressing()) {
                case Direct: {
                    this._tabbedPaneAudio.setSelectedComponent(this._panelAudioDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneAudio.setSelectedComponent(this._panelAudioReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneAudio.setSelectedComponent(this._panelAudioLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneAudio.setSelectedComponent(this._panelAudioFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            if (action.getAudio() != null) {
                this.audioBeanPanel.setDefaultNamedBean(action.getAudio().getBean());
            }
            this._audioReferenceTextField.setText(action.getReference());
            this._audioLocalVariableTextField.setText(action.getLocalVariable());
            this._audioFormulaTextField.setText(action.getFormula());
            switch (action.getOperationAddressing()) {
                case Direct: {
                    this._tabbedPaneAudioOperation.setSelectedComponent(this._panelAudioOperationDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneAudioOperation.setSelectedComponent(this._panelAudioOperationReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneAudioOperation.setSelectedComponent(this._panelAudioOperationLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneAudioOperation.setSelectedComponent(this._panelAudioOperationFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getAddressing().name());
                }
            }
            this._operationComboBox.setSelectedItem((Object)action.getOperation());
            this._audioOperationReferenceTextField.setText(action.getOperationReference());
            this._audioOperationLocalVariableTextField.setText(action.getOperationLocalVariable());
            this._audioOperationFormulaTextField.setText(action.getOperationFormula());
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneAudio, this._tabbedPaneAudioOperation};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionAudio_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block12: {
            ActionAudio action = new ActionAudio("IQDA1", null);
            try {
                if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioReference) {
                    action.setReference(this._audioReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                if (this._tabbedPaneAudioOperation.getSelectedComponent() == this._panelAudioOperationReference) {
                    action.setOperationReference(this._audioOperationReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setFormula(this._audioFormulaTextField.getText());
                if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                    break block12;
                }
                if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    break block12;
                }
                if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block12;
                }
                if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionAudio action = new ActionAudio(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block19: {
            if (!(object instanceof ActionAudio)) {
                throw new IllegalArgumentException("object must be an ActionAudio but is a: " + object.getClass().getName());
            }
            ActionAudio action = (ActionAudio)object;
            if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioDirect) {
                Audio audio = this.audioBeanPanel.getNamedBean();
                if (audio != null) {
                    NamedBeanHandle<Audio> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(audio.getDisplayName(), audio);
                    action.setAudio(handle);
                } else {
                    action.removeAudio();
                }
            } else {
                action.removeAudio();
            }
            try {
                if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioDirect) {
                    action.setAddressing(NamedBeanAddressing.Direct);
                } else if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioReference) {
                    action.setAddressing(NamedBeanAddressing.Reference);
                    action.setReference(this._audioReferenceTextField.getText());
                } else if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioLocalVariable) {
                    action.setAddressing(NamedBeanAddressing.LocalVariable);
                    action.setLocalVariable(this._audioLocalVariableTextField.getText());
                } else if (this._tabbedPaneAudio.getSelectedComponent() == this._panelAudioFormula) {
                    action.setAddressing(NamedBeanAddressing.Formula);
                    action.setFormula(this._audioFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneAudio has unknown selection");
                }
                if (this._tabbedPaneAudioOperation.getSelectedComponent() == this._panelAudioOperationDirect) {
                    action.setOperationAddressing(NamedBeanAddressing.Direct);
                    action.setOperation(this._operationComboBox.getItemAt(this._operationComboBox.getSelectedIndex()));
                    break block19;
                }
                if (this._tabbedPaneAudioOperation.getSelectedComponent() == this._panelAudioOperationReference) {
                    action.setOperationAddressing(NamedBeanAddressing.Reference);
                    action.setOperationReference(this._audioOperationReferenceTextField.getText());
                    break block19;
                }
                if (this._tabbedPaneAudioOperation.getSelectedComponent() == this._panelAudioOperationLocalVariable) {
                    action.setOperationAddressing(NamedBeanAddressing.LocalVariable);
                    action.setOperationLocalVariable(this._audioOperationLocalVariableTextField.getText());
                    break block19;
                }
                if (this._tabbedPaneAudioOperation.getSelectedComponent() == this._panelAudioOperationFormula) {
                    action.setOperationAddressing(NamedBeanAddressing.Formula);
                    action.setOperationFormula(this._audioOperationFormulaTextField.getText());
                    break block19;
                }
                throw new IllegalArgumentException("_tabbedPaneAudioOperation has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionAudio_Short");
    }

    @Override
    public void dispose() {
        if (this.audioBeanPanel != null) {
            this.audioBeanPanel.dispose();
        }
    }
}

