/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.Timeout;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class TimeoutXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        Timeout p = (Timeout)o;
        Element element = new Element("Timeout");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e2 = new Element("ExpressionSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(0).getName()));
        MaleSocket socket = p.getExpressionSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getExpressionSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        e2 = new Element("ActionSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(1).getName()));
        socket = p.getActionSocket().getConnectedSocket();
        socketSystemName = socket != null ? socket.getSystemName() : p.getActionSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        element.addContent((Content)new Element("delayAddressing").addContent(p.getDelayAddressing().name()));
        element.addContent((Content)new Element("delay").addContent(Integer.toString(p.getDelay())));
        element.addContent((Content)new Element("delayReference").addContent(p.getDelayReference()));
        element.addContent((Content)new Element("delayLocalVariable").addContent(p.getDelayLocalVariable()));
        element.addContent((Content)new Element("delayFormula").addContent(p.getDelayFormula()));
        element.addContent((Content)new Element("unit").addContent(p.getUnit().name()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        Timeout h = new Timeout(sys, uname);
        this.loadCommon(h, shared);
        Element delayElement = shared.getChild("delay");
        int delay = 0;
        if (delayElement != null) {
            delay = Integer.parseInt(delayElement.getText());
        }
        h.setDelay(delay);
        Element unit = shared.getChild("unit");
        if (unit != null) {
            h.setUnit(TimerUnit.valueOf(unit.getTextTrim()));
        }
        try {
            Element elem = shared.getChild("delayAddressing");
            if (elem != null) {
                h.setDelayAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("delayReference")) != null) {
                h.setDelayReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("delayLocalVariable")) != null) {
                h.setDelayLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("delayFormula")) != null) {
                h.setDelayFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        Element socketName = shared.getChild("ExpressionSocket").getChild("socketName");
        h.getChild(0).setName(socketName.getTextTrim());
        Element socketSystemName = shared.getChild("ExpressionSocket").getChild("systemName");
        if (socketSystemName != null) {
            h.setExpressionSocketSystemName(socketSystemName.getTextTrim());
        }
        socketName = shared.getChild("ActionSocket").getChild("socketName");
        h.getChild(1).setName(socketName.getTextTrim());
        socketSystemName = shared.getChild("ActionSocket").getChild("systemName");
        if (socketSystemName != null) {
            h.setActionSocketSystemName(socketSystemName.getTextTrim());
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

