/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ShowDialog;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDialogXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ShowDialogXml.class);

    @Override
    public Element store(Object o) {
        ShowDialog p = (ShowDialog)o;
        Element element = new Element("ShowDialog");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e2 = new Element("Socket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(0).getName()));
        MaleSocket socket = p.getSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        Element buttons = new Element("Buttons");
        ShowDialog.Button[] buttonArray = ShowDialog.Button.values();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShowDialog.Button button = buttonArray[n2];
            if (p.getEnabledButtons().contains((Object)button)) {
                buttons.addContent((Content)new Element("name").addContent(button.name()));
            }
            ++n2;
        }
        element.addContent((Content)buttons);
        element.addContent((Content)new Element("formatType").addContent(p.getFormatType().name()));
        element.addContent((Content)new Element("format").addContent(p.getFormat()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("modal").addContent(p.getModal() ? "yes" : "no"));
        element.addContent((Content)new Element("multiLine").addContent(p.getMultiLine() ? "yes" : "no"));
        Element parameters = new Element("DataList");
        for (ShowDialog.Data data : p.getDataList()) {
            Element elementParameter = new Element("Data");
            elementParameter.addContent((Content)new Element("type").addContent(data.getDataType().name()));
            elementParameter.addContent((Content)new Element("data").addContent(data.getData()));
            parameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)parameters);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ShowDialog h = new ShowDialog(sys, uname);
        this.loadCommon(h, shared);
        Element socketNameElement = shared.getChild("Socket").getChild("socketName");
        String socketName = socketNameElement.getTextTrim();
        Element socketSystemNameElement = shared.getChild("Socket").getChild("systemName");
        String socketSystemName = null;
        if (socketSystemNameElement != null) {
            socketSystemName = socketSystemNameElement.getTextTrim();
        }
        h.getChild(0).setName(socketName);
        h.setSocketSystemName(socketSystemName);
        List buttons = shared.getChild("Buttons").getChildren();
        Set<ShowDialog.Button> enabledButtons = h.getEnabledButtons();
        enabledButtons.clear();
        for (Element e : buttons) {
            enabledButtons.add(ShowDialog.Button.valueOf(e.getTextTrim()));
        }
        Element elem = shared.getChild("formatType");
        h.setFormatType(elem != null ? ShowDialog.FormatType.valueOf(elem.getTextTrim()) : ShowDialog.FormatType.OnlyText);
        elem = shared.getChild("format");
        h.setFormat(elem != null ? elem.getValue() : "");
        elem = shared.getChild("localVariable");
        h.setLocalVariable(elem != null ? elem.getValue() : "");
        elem = shared.getChild("modal");
        h.setModal(elem != null ? elem.getTextTrim().equals("yes") : false);
        elem = shared.getChild("multiLine");
        h.setMultiLine(elem != null ? elem.getTextTrim().equals("yes") : false);
        List dataList = shared.getChild("DataList").getChildren();
        log.debug("Found " + dataList.size() + " dataList");
        for (Element e : dataList) {
            Element elementName;
            ShowDialog.DataType type = ShowDialog.DataType.LocalVariable;
            Element elementType = e.getChild("type");
            if (elementType != null) {
                type = ShowDialog.DataType.valueOf(elementType.getTextTrim());
            }
            if ((elementName = e.getChild("data")) == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            try {
                h.getDataList().add(new ShowDialog.Data(type, elementName.getTextTrim()));
            }
            catch (ParserException ex) {
                log.warn(ex.getMessage());
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

