/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.LogData;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDataXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(LogDataXml.class);

    @Override
    public Element store(Object o) {
        LogData p = (LogData)o;
        Element element = new Element("LogData");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)new Element("logToLog").addContent(p.getLogToLog() ? "yes" : "no"));
        element.addContent((Content)new Element("logToScriptOutput").addContent(p.getLogToScriptOutput() ? "yes" : "no"));
        element.addContent((Content)new Element("formatType").addContent(p.getFormatType().name()));
        element.addContent((Content)new Element("format").addContent(p.getFormat()));
        Element parameters = new Element("DataList");
        for (LogData.Data data : p.getDataList()) {
            Element elementParameter = new Element("Data");
            elementParameter.addContent((Content)new Element("type").addContent(data.getDataType().name()));
            elementParameter.addContent((Content)new Element("data").addContent(data.getData()));
            parameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)parameters);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        LogData h = new LogData(sys, uname);
        this.loadCommon(h, shared);
        Element elem = shared.getChild("logToLog");
        h.setLogToLog(elem != null ? elem.getTextTrim().equals("yes") : false);
        elem = shared.getChild("logToScriptOutput");
        h.setLogToScriptOutput(elem != null ? elem.getTextTrim().equals("yes") : false);
        elem = shared.getChild("formatType");
        h.setFormatType(elem != null ? LogData.FormatType.valueOf(elem.getTextTrim()) : LogData.FormatType.OnlyText);
        elem = shared.getChild("format");
        h.setFormat(elem != null ? elem.getValue() : "");
        List dataList = shared.getChild("DataList").getChildren();
        log.debug("Found " + dataList.size() + " dataList");
        for (Element e : dataList) {
            Element elementName;
            LogData.DataType type = LogData.DataType.LocalVariable;
            Element elementType = e.getChild("type");
            if (elementType != null) {
                type = LogData.DataType.valueOf(elementType.getTextTrim());
            }
            if ((elementName = e.getChild("data")) == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            try {
                h.getDataList().add(new LogData.Data(type, elementName.getTextTrim()));
            }
            catch (ParserException ex) {
                log.warn(ex.getMessage());
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

