/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ExecuteDelayed;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExecuteDelayedXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ExecuteDelayed p = (ExecuteDelayed)o;
        Element element = new Element("ExecuteDelayed");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e2 = new Element("Socket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(0).getName()));
        MaleSocket socket = p.getSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        element.addContent((Content)new Element("delayAddressing").addContent(p.getDelayAddressing().name()));
        element.addContent((Content)new Element("delay").addContent(Integer.toString(p.getDelay())));
        element.addContent((Content)new Element("delayReference").addContent(p.getDelayReference()));
        element.addContent((Content)new Element("delayLocalVariable").addContent(p.getDelayLocalVariable()));
        element.addContent((Content)new Element("delayFormula").addContent(p.getDelayFormula()));
        element.addContent((Content)new Element("unit").addContent(p.getUnit().name()));
        element.addContent((Content)new Element("resetIfAlreadyStarted").addContent(p.getResetIfAlreadyStarted() ? "yes" : "no"));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element socketNameElement = shared.getChild("Socket").getChild("socketName");
        String socketName = socketNameElement.getTextTrim();
        Element socketSystemNameElement = shared.getChild("Socket").getChild("systemName");
        String socketSystemName = null;
        if (socketSystemNameElement != null) {
            socketSystemName = socketSystemNameElement.getTextTrim();
        }
        Element delayElement = shared.getChild("delay");
        int delay = 0;
        if (delayElement != null) {
            delay = Integer.parseInt(delayElement.getText());
        }
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExecuteDelayed h = new ExecuteDelayed(sys, uname);
        this.loadCommon(h, shared);
        h.getChild(0).setName(socketName);
        h.setSocketSystemName(socketSystemName);
        h.setDelay(delay);
        Element unit = shared.getChild("unit");
        if (unit != null) {
            h.setUnit(TimerUnit.valueOf(unit.getTextTrim()));
        }
        String resetIfAlreadyStarted = "no";
        if (shared.getChild("resetIfAlreadyStarted") != null) {
            resetIfAlreadyStarted = shared.getChild("resetIfAlreadyStarted").getTextTrim();
        }
        h.setResetIfAlreadyStarted("yes".equals(resetIfAlreadyStarted));
        try {
            Element elem = shared.getChild("delayAddressing");
            if (elem != null) {
                h.setDelayAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("delayReference")) != null) {
                h.setDelayReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("delayLocalVariable")) != null) {
                h.setDelayLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("delayFormula")) != null) {
                h.setDelayFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

