/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.EnableLogix;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class EnableLogixXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        EnableLogix p = (EnableLogix)o;
        Element element = new Element("EnableLogix");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Logix> logix = p.getLogix();
        if (logix != null) {
            element.addContent((Content)new Element("logix").addContent(logix.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationDirect").addContent(p.getOperationDirect().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getLockFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        EnableLogix h = new EnableLogix(sys, uname);
        this.loadCommon(h, shared);
        Element logixName = shared.getChild("logix");
        if (logixName != null) {
            Logix t = InstanceManager.getDefault(LogixManager.class).getLogix(logixName.getTextTrim());
            if (t != null) {
                h.setLogix(t);
            } else {
                h.removeLogix();
            }
        }
        try {
            Element logixLock;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationAddressing")) != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((logixLock = shared.getChild("operationDirect")) != null) {
                h.setOperationDirect(EnableLogix.Operation.valueOf(logixLock.getTextTrim()));
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

