/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.DigitalCallModule;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalCallModuleXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DigitalCallModuleXml.class);

    @Override
    public Element store(Object o) {
        DigitalCallModule p = (DigitalCallModule)o;
        Element element = new Element("CallModule");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Module> module = p.getModule();
        if (module != null) {
            element.addContent((Content)new Element("module").addContent(module.getName()));
        }
        Element parameters = new Element("Parameters");
        for (Module.ParameterData pd : p.getParameterData()) {
            Element elementParameter = new Element("Parameter");
            elementParameter.addContent((Content)new Element("name").addContent(pd._name));
            elementParameter.addContent((Content)new Element("initalValueType").addContent(pd._initialValueType.name()));
            elementParameter.addContent((Content)new Element("initialValueData").addContent(pd._initialValueData));
            elementParameter.addContent((Content)new Element("returnValueType").addContent(pd._returnValueType.name()));
            elementParameter.addContent((Content)new Element("returnValueData").addContent(pd._returnValueData));
            parameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)parameters);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        DigitalCallModule h = new DigitalCallModule(sys, uname);
        this.loadCommon(h, shared);
        Element moduleName = shared.getChild("module");
        if (moduleName != null) {
            Module t = InstanceManager.getDefault(ModuleManager.class).getModule(moduleName.getTextTrim());
            if (t != null) {
                h.setModule(t);
            } else {
                h.removeModule();
            }
        }
        List parameterList = shared.getChild("Parameters").getChildren();
        log.debug("Found " + parameterList.size() + " parameters");
        for (Element e : parameterList) {
            Element elementName = e.getChild("name");
            SymbolTable.InitialValueType initialValueType = null;
            Element elementType = e.getChild("initalValueType");
            if (elementType != null) {
                initialValueType = SymbolTable.InitialValueType.valueOf(elementType.getTextTrim());
            }
            Element elementInitialValueData = e.getChild("initialValueData");
            Module.ReturnValueType returnValueType = null;
            elementType = e.getChild("returnValueType");
            if (elementType != null) {
                returnValueType = Module.ReturnValueType.valueOf(elementType.getTextTrim());
            }
            Element elementReturnValueData = e.getChild("returnValueData");
            if (elementName == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            if (initialValueType == null) {
                throw new IllegalArgumentException("Element 'initalValueType' does not exists");
            }
            if (elementInitialValueData == null) {
                throw new IllegalArgumentException("Element 'initialValueData' does not exists");
            }
            if (returnValueType == null) {
                throw new IllegalArgumentException("Element 'returnValueType' does not exists");
            }
            if (elementReturnValueData == null) {
                throw new IllegalArgumentException("Element 'returnValueData' does not exists");
            }
            h.addParameter(elementName.getTextTrim(), initialValueType, elementInitialValueData.getTextTrim(), returnValueType, elementReturnValueData.getTextTrim());
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

