/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionTurnoutLock;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionTurnoutLockXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ActionTurnoutLock p = (ActionTurnoutLock)o;
        Element element = new Element("ActionTurnoutLock");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Turnout> turnout = p.getTurnout();
        if (turnout != null) {
            element.addContent((Content)new Element("turnout").addContent(turnout.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("stateAddressing").addContent(p.getLockAddressing().name()));
        element.addContent((Content)new Element("turnoutLock").addContent(p.getTurnoutLock().name()));
        element.addContent((Content)new Element("stateReference").addContent(p.getLockReference()));
        element.addContent((Content)new Element("stateLocalVariable").addContent(p.getLockLocalVariable()));
        element.addContent((Content)new Element("stateFormula").addContent(p.getLockFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionTurnoutLock h = new ActionTurnoutLock(sys, uname);
        this.loadCommon(h, shared);
        Element turnoutName = shared.getChild("turnout");
        if (turnoutName != null) {
            Turnout t = InstanceManager.getDefault(TurnoutManager.class).getTurnout(turnoutName.getTextTrim());
            if (t != null) {
                h.setTurnout(t);
            } else {
                h.removeTurnout();
            }
        }
        try {
            Element turnoutLock;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateAddressing")) != null) {
                h.setLockAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((turnoutLock = shared.getChild("turnoutLock")) != null) {
                h.setTurnoutLock(ActionTurnoutLock.TurnoutLock.valueOf(turnoutLock.getTextTrim()));
            }
            if ((elem = shared.getChild("stateReference")) != null) {
                h.setLockReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateLocalVariable")) != null) {
                h.setLockLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateFormula")) != null) {
                h.setLockFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

